/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sign.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.sign.config.properties.SignProperties;
import cn.stylefeng.roses.kernel.sign.service.SignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSignService
implements SignService {
    private static final Logger log = LoggerFactory.getLogger(SimpleSignService.class);
    private static final long DEAULT_SIGN_EXPIRED_SECONDS = 60L;

    private static long getExpiredTime() {
        SignProperties signProperties = null;
        try {
            signProperties = (SignProperties)SpringContextHolder.getBean(SignProperties.class);
        }
        catch (RuntimeException e) {
            return 60L;
        }
        if (signProperties == null || signProperties.getTime() == 0L) {
            return 60L;
        }
        return signProperties.getTime();
    }

    public static String generateSign(String appId, String secret, String timestamp, String data) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{appId, secret, timestamp, data})) {
            throw new IllegalArgumentException("\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a!appId=" + appId + ",secret=" + secret + ",timestamp=" + timestamp + ",data=" + data);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(appId);
        buf.append(secret);
        buf.append(timestamp);
        buf.append(data);
        return ToolUtil.md5Hex((String)buf.toString());
    }

    public static boolean validateSign(String appId, String secret, String timestamp, String data, String sign) {
        return SimpleSignService.validateSign(appId, secret, timestamp, data, sign, SimpleSignService.getExpiredTime());
    }

    public static boolean validateSign(String appId, String secret, String timestamp, String data, String sign, long expiredSeconds) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{appId, secret, timestamp, data, sign})) {
            throw new IllegalArgumentException("\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a!appId=" + appId + ",secret=" + secret + ",timestamp=" + timestamp + ",data=" + data + ",sign=" + sign);
        }
        DateTime timestampDate = null;
        try {
            timestampDate = DateUtil.parse((String)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u7b7e\u540d\u662f\u5426\u6709\u6548\u5f02\u5e38\uff01\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
        long now = System.currentTimeMillis();
        long signTime = timestampDate.getTime();
        if ((now - signTime) / 1000L > expiredSeconds) {
            return false;
        }
        String nowSign = SimpleSignService.generateSign(appId, secret, timestamp, data);
        return nowSign.equals(sign);
    }
}

