/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.modular.factory;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.model.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.modular.factory.ApiResourceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultApiResourceFactory
implements ApiResourceFactory {
    private Map<String, ResourceDefinition> resourceDefinitions = new ConcurrentHashMap<String, ResourceDefinition>();
    private Map<String, Map<String, ResourceDefinition>> modularResourceDefinitions = new ConcurrentHashMap<String, Map<String, ResourceDefinition>>();
    private Map<String, String> resourceCodeNameDict = new HashMap<String, String>();
    private Map<String, ResourceDefinition> urlDefineResources = new ConcurrentHashMap<String, ResourceDefinition>();

    @Override
    public synchronized void registerDefinition(List<ResourceDefinition> apiResource) {
        if (apiResource != null || apiResource.size() > 0) {
            for (ResourceDefinition resourceDefinition : apiResource) {
                ResourceDefinition alreadyFlag = this.resourceDefinitions.get(resourceDefinition.getCode());
                if (alreadyFlag != null) {
                    throw new RuntimeException("\u8d44\u6e90\u626b\u63cf\u8fc7\u7a0b\u4e2d\u5b58\u5728\u91cd\u590d\u8d44\u6e90\uff01\n\u5df2\u5b58\u5728\u8d44\u6e90\uff1a" + alreadyFlag + "\n\u65b0\u8d44\u6e90\u4e3a\uff1a " + resourceDefinition);
                }
                this.resourceDefinitions.put(resourceDefinition.getCode(), resourceDefinition);
                this.urlDefineResources.put(resourceDefinition.getUrl(), resourceDefinition);
                Map<String, ResourceDefinition> modularResources = this.modularResourceDefinitions.get(StrUtil.toUnderlineCase((CharSequence)resourceDefinition.getModularCode()));
                if (modularResources == null) {
                    modularResources = new HashMap<String, ResourceDefinition>();
                    modularResources.put(resourceDefinition.getCode(), resourceDefinition);
                    this.modularResourceDefinitions.put(StrUtil.toUnderlineCase((CharSequence)resourceDefinition.getModularCode()), modularResources);
                } else {
                    modularResources.put(resourceDefinition.getCode(), resourceDefinition);
                }
                this.bindResourceName(resourceDefinition.getCode(), resourceDefinition.getName());
            }
        }
    }

    @Override
    public ResourceDefinition getResource(String resourceCode) {
        return this.resourceDefinitions.get(resourceCode);
    }

    @Override
    public List<ResourceDefinition> getAllResources() {
        Set<Map.Entry<String, ResourceDefinition>> entries = this.resourceDefinitions.entrySet();
        ArrayList<ResourceDefinition> resourceDefinitions = new ArrayList<ResourceDefinition>();
        for (Map.Entry<String, ResourceDefinition> entry : entries) {
            resourceDefinitions.add(entry.getValue());
        }
        return resourceDefinitions;
    }

    @Override
    public List<ResourceDefinition> getResourcesByModularCode(String code) {
        Map<String, ResourceDefinition> stringResourceDefinitionMap = this.modularResourceDefinitions.get(code);
        ArrayList<ResourceDefinition> resourceDefinitions = new ArrayList<ResourceDefinition>();
        for (String key : stringResourceDefinitionMap.keySet()) {
            ResourceDefinition resourceDefinition = stringResourceDefinitionMap.get(key);
            resourceDefinitions.add(resourceDefinition);
        }
        return resourceDefinitions;
    }

    @Override
    public String getResourceName(String code) {
        return this.resourceCodeNameDict.get(code);
    }

    @Override
    public void bindResourceName(String code, String name) {
        this.resourceCodeNameDict.putIfAbsent(code, name);
    }

    @Override
    public Map<String, Map<String, ResourceDefinition>> getModularResources() {
        return this.modularResourceDefinitions;
    }

    @Override
    public String getResourceUrl(String code) {
        ResourceDefinition resourceDefinition = this.resourceDefinitions.get(code);
        if (resourceDefinition == null) {
            return null;
        }
        return resourceDefinition.getUrl();
    }

    @Override
    public ResourceDefinition getResourceByUrl(String url) {
        return this.urlDefineResources.get(url);
    }
}

