/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.modular.service;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.model.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.config.properties.ScannerProperties;
import cn.stylefeng.roses.kernel.scanner.modular.factory.ApiResourceFactory;
import cn.stylefeng.roses.kernel.scanner.modular.model.ResourceTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ResourceCollectService {
    public static final String APP_CODE_PREFIX = "appType-";
    public static final String CONTROLLER_CODE_PREFIX = "conType-";
    public static final String RESOURCE_CODE_PREFIX = "resType-";
    private ApiResourceFactory apiResourceFactory;
    private ScannerProperties scannerProperties;

    public ResourceCollectService(ApiResourceFactory apiResourceFactory, ScannerProperties scannerProperties) {
        this.apiResourceFactory = apiResourceFactory;
        this.scannerProperties = scannerProperties;
    }

    public List<ResourceDefinition> getAllAppResourceList(String code, String resourceName) {
        if (StrUtil.isBlank((CharSequence)code)) {
            List<ResourceDefinition> result = this.apiResourceFactory.getAllResources();
            return this.findResource(resourceName, result);
        }
        List<ResourceDefinition> result = null;
        if (code.startsWith(APP_CODE_PREFIX)) {
            result = this.apiResourceFactory.getAllResources();
        } else if (code.startsWith(CONTROLLER_CODE_PREFIX)) {
            result = this.apiResourceFactory.getResourcesByModularCode(code.replace(CONTROLLER_CODE_PREFIX, ""));
        } else if (code.startsWith(RESOURCE_CODE_PREFIX)) {
            ResourceDefinition resourceDefinitions = this.apiResourceFactory.getResource(code.replace(CONTROLLER_CODE_PREFIX, ""));
            result = Arrays.asList(resourceDefinitions);
        }
        return this.findResource(resourceName, result);
    }

    public List<ResourceTreeNode> getResourceTree() {
        ArrayList<ResourceTreeNode> resourceTreeNodes = new ArrayList<ResourceTreeNode>();
        ResourceTreeNode appResources = new ResourceTreeNode();
        appResources.setName(this.scannerProperties.getAppName());
        appResources.setCode(APP_CODE_PREFIX + this.scannerProperties.getAppCode());
        appResources.setChildren(new ArrayList<ResourceTreeNode>());
        Map<String, Map<String, ResourceDefinition>> modularResources = this.apiResourceFactory.getModularResources();
        for (String modularCode : modularResources.keySet()) {
            ArrayList<ResourceTreeNode> modularResourceTreeNode = new ArrayList<ResourceTreeNode>();
            Map<String, ResourceDefinition> stringResourceDefinitionMap = modularResources.get(modularCode);
            for (Map.Entry<String, ResourceDefinition> entry : stringResourceDefinitionMap.entrySet()) {
                ResourceDefinition value = entry.getValue();
                modularResourceTreeNode.add(new ResourceTreeNode(value.getName(), RESOURCE_CODE_PREFIX + value.getCode()));
            }
            appResources.getChildren().add(new ResourceTreeNode(this.apiResourceFactory.getResourceName(modularCode), CONTROLLER_CODE_PREFIX + modularCode, modularResourceTreeNode));
        }
        resourceTreeNodes.add(appResources);
        return resourceTreeNodes;
    }

    private List<ResourceDefinition> findResource(String resourceName, List<ResourceDefinition> resourceDefinitions) {
        if (StrUtil.isBlank((CharSequence)resourceName)) {
            return resourceDefinitions;
        }
        for (ResourceDefinition resourceDefinition : resourceDefinitions) {
            if (!resourceDefinition.getName().equals(resourceName)) continue;
            return Arrays.asList(resourceDefinition);
        }
        return null;
    }
}

