/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.config;

import cn.stylefeng.roses.kernel.scanner.config.properties.ScannerProperties;
import cn.stylefeng.roses.kernel.scanner.modular.ApiResourceScaner;
import cn.stylefeng.roses.kernel.scanner.modular.factory.ApiResourceFactory;
import cn.stylefeng.roses.kernel.scanner.modular.factory.DefaultApiResourceFactory;
import cn.stylefeng.roses.kernel.scanner.modular.listener.ResourceReportListener;
import cn.stylefeng.roses.kernel.scanner.modular.service.ResourceCollectService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ScannerAutoConfiguration {
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Bean
    @ConfigurationProperties(prefix="roses.scanner")
    public ScannerProperties scannerProperties() {
        return new ScannerProperties();
    }

    @Bean
    public ApiResourceFactory apiResourceFactory() {
        return new DefaultApiResourceFactory();
    }

    @Bean
    public ResourceCollectService resourceCollectService(ApiResourceFactory apiResourceFactory, ScannerProperties scannerProperties) {
        return new ResourceCollectService(apiResourceFactory, scannerProperties);
    }

    @Bean
    public ApiResourceScaner apiResourceScaner(ApiResourceFactory apiResourceFactory, ScannerProperties scannerProperties) {
        return new ApiResourceScaner(apiResourceFactory, scannerProperties, this.applicationName);
    }

    @Bean
    @ConditionalOnProperty(prefix="roses.scanner", name={"open"}, havingValue="true")
    public ResourceReportListener resourceReportListener() {
        return new ResourceReportListener();
    }
}

