/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.jwt.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.Map;

public class JwtTokenUtil {
    private String jwtSecret;
    private Long defaultExpiredDate;

    public JwtTokenUtil(String jwtSecret, Long defaultExpiredDate) {
        this.jwtSecret = jwtSecret;
        this.defaultExpiredDate = defaultExpiredDate;
    }

    public String getUserIdFromToken(String token) {
        return this.getClaimFromToken(token).getSubject();
    }

    public Date getIssuedAtDateFromToken(String token) {
        return this.getClaimFromToken(token).getIssuedAt();
    }

    public Date getExpirationDateFromToken(String token) {
        return this.getClaimFromToken(token).getExpiration();
    }

    public String getAudienceFromToken(String token) {
        return this.getClaimFromToken(token).getAudience();
    }

    public String getPrivateClaimFromToken(String token, String key) {
        return this.getClaimFromToken(token).get((Object)key).toString();
    }

    public Claims getClaimFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody();
    }

    public Boolean checkToken(String token) throws JwtException {
        try {
            Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody();
            return true;
        }
        catch (JwtException e) {
            return false;
        }
    }

    public Boolean isTokenExpired(String token) {
        try {
            Date expiration = this.getExpirationDateFromToken(token);
            return expiration.before(new Date());
        }
        catch (ExpiredJwtException expiredJwtException) {
            return true;
        }
    }

    public String generateToken(String userId, Map<String, Object> claims) {
        Date expirationDate = new Date(System.currentTimeMillis() + this.defaultExpiredDate * 1000L);
        return this.generateToken(userId, expirationDate, claims);
    }

    public String generateToken(String userId, Date exppiredDate, Map<String, Object> claims) {
        Date createdDate = new Date();
        if (claims == null) {
            return Jwts.builder().setSubject(userId).setIssuedAt(createdDate).setExpiration(exppiredDate).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
        }
        return Jwts.builder().setClaims(claims).setSubject(userId).setIssuedAt(createdDate).setExpiration(exppiredDate).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }
}

