/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.data;

import cn.stylefeng.roses.core.util.SpringContextHolder;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.Collection;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSqlExe {
    private static final Logger log = LoggerFactory.getLogger(BatchSqlExe.class);

    public static <T> void saveBatch(SqlSessionFactory sqlSessionFactory, Class<T> clazz, Collection<T> entityList) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);){
            String sqlStatement = SqlHelper.table(clazz).getSqlStatement(SqlMethod.INSERT_ONE.getMethod());
            for (T entity : entityList) {
                sqlSession.insert(sqlStatement, entity);
            }
            sqlSession.flushStatements();
            sqlSession.commit();
        }
    }

    public static <T> void saveBatch(Class<T> clazz, Collection<T> entityList) {
        SqlSessionFactory sqlSessionFactory = SpringContextHolder.getBean(SqlSessionFactory.class);
        BatchSqlExe.saveBatch(sqlSessionFactory, clazz, entityList);
    }

    public static <T> void updateBatchById(SqlSessionFactory sqlSessionFactory, Class<T> clazz, Collection<T> entityList) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);){
            String sqlStatement = SqlHelper.table(clazz).getSqlStatement(SqlMethod.UPDATE_BY_ID.getMethod());
            for (T anEntityList : entityList) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", anEntityList);
                sqlSession.update(sqlStatement, (Object)param);
            }
            sqlSession.flushStatements();
            sqlSession.commit();
        }
    }

    public static <T> void updateBatchById(Class<T> clazz, Collection<T> entityList) {
        SqlSessionFactory sqlSessionFactory = SpringContextHolder.getBean(SqlSessionFactory.class);
        BatchSqlExe.updateBatchById(sqlSessionFactory, clazz, entityList);
    }
}

