/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.page;

import cn.stylefeng.roses.core.context.RequestDataHolder;
import cn.stylefeng.roses.core.request.RequestData;
import cn.stylefeng.roses.core.util.HttpContext;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.page.PageQuery;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import javax.servlet.http.HttpServletRequest;

public class PageFactory {
    private static final String ASC = "asc";
    private static final String PAGE_SIZE_PARAM_NAME = "pageSize";
    private static final String PAGE_NO_PARAM_NAME = "pageNo";
    private static final String SORT_PARAM_NAME = "sort";
    private static final String ORDER_BY_PARAM_NAME = "orderBy";

    public static <T> Page<T> defaultPage() {
        String pageNoString;
        int pageSize = 20;
        int pageNo = 1;
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            return new Page((long)pageNo, (long)pageSize);
        }
        String pageSizeString = PageFactory.getFieldValue(request, PAGE_SIZE_PARAM_NAME);
        if (ValidateUtil.isNotEmpty((Object)pageSizeString)) {
            pageSize = Integer.valueOf(pageSizeString);
        }
        if (ValidateUtil.isNotEmpty((Object)(pageNoString = PageFactory.getFieldValue(request, PAGE_NO_PARAM_NAME)))) {
            pageNo = Integer.valueOf(pageNoString);
        }
        String sort = PageFactory.getFieldValue(request, SORT_PARAM_NAME);
        String orderByField = PageFactory.getFieldValue(request, ORDER_BY_PARAM_NAME);
        Page page = new Page((long)pageNo, (long)pageSize);
        if (ToolUtil.isEmpty((Object)orderByField)) {
            return page;
        }
        if (ToolUtil.isEmpty((Object)sort)) {
            page.setDesc(new String[]{orderByField});
            return page;
        }
        if (ASC.equalsIgnoreCase(sort)) {
            page.setAsc(new String[]{orderByField});
        } else {
            page.setDesc(new String[]{orderByField});
        }
        return page;
    }

    public static <T> Page<T> createPage(PageQuery pageQuery) {
        int pageSize = 20;
        int pageNo = 1;
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageSize())) {
            pageSize = pageQuery.getPageSize();
        }
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageNo())) {
            pageNo = pageQuery.getPageNo();
        }
        if (pageQuery == null) {
            return new Page((long)pageNo, (long)pageSize);
        }
        Page page = new Page((long)pageNo, (long)pageSize);
        if (ToolUtil.isEmpty((Object)pageQuery.getSort())) {
            return page;
        }
        if (ASC.equalsIgnoreCase(pageQuery.getSort())) {
            page.setAsc(new String[]{pageQuery.getOrderByField()});
        } else {
            page.setDesc(new String[]{pageQuery.getOrderByField()});
        }
        return page;
    }

    private static String getFieldValue(HttpServletRequest request, String fieldName) {
        String parameter = request.getParameter(fieldName);
        if (parameter == null) {
            RequestData requestData = RequestDataHolder.get();
            if (requestData == null) {
                return null;
            }
            Object fieldValue = requestData.get(fieldName);
            if (fieldValue == null) {
                return null;
            }
            return fieldValue.toString();
        }
        return null;
    }
}

