/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.config.properties;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.Properties;

public class DruidProperties {
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private Integer initialSize = 2;
    private Integer minIdle = 1;
    private Integer maxActive = 20;
    private Integer maxWait = 60000;
    private Integer timeBetweenEvictionRunsMillis = 60000;
    private Integer minEvictableIdleTimeMillis = 300000;
    private String validationQuery;
    private Boolean testWhileIdle = true;
    private Boolean testOnBorrow = false;
    private Boolean testOnReturn = false;
    private Boolean poolPreparedStatements = true;
    private Integer maxPoolPreparedStatementPerConnectionSize = 20;
    private String filters = "stat";
    private String dataSourceName;

    public void config(DruidDataSource dataSource) {
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setInitialSize(this.initialSize.intValue());
        dataSource.setMinIdle(this.minIdle.intValue());
        dataSource.setMaxActive(this.maxActive.intValue());
        dataSource.setMaxWait((long)this.maxWait.intValue());
        dataSource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis.intValue());
        dataSource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
        dataSource.setValidationQuery(this.getValidateQueryByUrl(this.url));
        dataSource.setTestWhileIdle(this.testWhileIdle.booleanValue());
        dataSource.setTestOnBorrow(this.testOnBorrow.booleanValue());
        dataSource.setTestOnReturn(this.testOnReturn.booleanValue());
        dataSource.setPoolPreparedStatements(this.poolPreparedStatements.booleanValue());
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize.intValue());
        try {
            dataSource.setFilters(this.filters);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Properties createProperties() {
        Properties properties = new Properties();
        properties.put("url", this.url);
        properties.put("username", this.username);
        properties.put("password", this.password);
        properties.put("driverClassName", this.driverClassName);
        properties.put("initialSize", this.initialSize);
        properties.put("maxActive", this.maxActive);
        properties.put("minIdle", this.minIdle);
        properties.put("maxWait", this.maxWait);
        properties.put("poolPreparedStatements", this.poolPreparedStatements);
        properties.put("maxPoolPreparedStatementPerConnectionSize", this.maxPoolPreparedStatementPerConnectionSize);
        properties.put("validationQuery", this.getValidateQueryByUrl(this.url));
        properties.put("testOnBorrow", this.testOnBorrow);
        properties.put("testOnReturn", this.testOnReturn);
        properties.put("testWhileIdle", this.testWhileIdle);
        properties.put("timeBetweenEvictionRunsMillis", this.timeBetweenEvictionRunsMillis);
        properties.put("minEvictableIdleTimeMillis", this.minEvictableIdleTimeMillis);
        properties.put("filters", this.filters);
        return properties;
    }

    private String getValidateQueryByUrl(String url) {
        if (url.contains("oracle")) {
            return "select 1 from dual";
        }
        if (url.contains("postgresql")) {
            return "select version()";
        }
        if (url.contains("sqlserver")) {
            return "select 1";
        }
        return "select 1";
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public Integer getMaxWait() {
        return this.maxWait;
    }

    public Integer getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Integer getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public Boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Integer getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public String getFilters() {
        return this.filters;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(Integer timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(Integer minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setPoolPreparedStatements(Boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(Integer maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidProperties)) {
            return false;
        }
        DruidProperties other = (DruidProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        Integer this$initialSize = this.getInitialSize();
        Integer other$initialSize = other.getInitialSize();
        if (this$initialSize == null ? other$initialSize != null : !((Object)this$initialSize).equals(other$initialSize)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Integer this$maxActive = this.getMaxActive();
        Integer other$maxActive = other.getMaxActive();
        if (this$maxActive == null ? other$maxActive != null : !((Object)this$maxActive).equals(other$maxActive)) {
            return false;
        }
        Integer this$maxWait = this.getMaxWait();
        Integer other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Integer this$timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        Integer other$timeBetweenEvictionRunsMillis = other.getTimeBetweenEvictionRunsMillis();
        if (this$timeBetweenEvictionRunsMillis == null ? other$timeBetweenEvictionRunsMillis != null : !((Object)this$timeBetweenEvictionRunsMillis).equals(other$timeBetweenEvictionRunsMillis)) {
            return false;
        }
        Integer this$minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        Integer other$minEvictableIdleTimeMillis = other.getMinEvictableIdleTimeMillis();
        if (this$minEvictableIdleTimeMillis == null ? other$minEvictableIdleTimeMillis != null : !((Object)this$minEvictableIdleTimeMillis).equals(other$minEvictableIdleTimeMillis)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        Boolean this$testWhileIdle = this.getTestWhileIdle();
        Boolean other$testWhileIdle = other.getTestWhileIdle();
        if (this$testWhileIdle == null ? other$testWhileIdle != null : !((Object)this$testWhileIdle).equals(other$testWhileIdle)) {
            return false;
        }
        Boolean this$testOnBorrow = this.getTestOnBorrow();
        Boolean other$testOnBorrow = other.getTestOnBorrow();
        if (this$testOnBorrow == null ? other$testOnBorrow != null : !((Object)this$testOnBorrow).equals(other$testOnBorrow)) {
            return false;
        }
        Boolean this$testOnReturn = this.getTestOnReturn();
        Boolean other$testOnReturn = other.getTestOnReturn();
        if (this$testOnReturn == null ? other$testOnReturn != null : !((Object)this$testOnReturn).equals(other$testOnReturn)) {
            return false;
        }
        Boolean this$poolPreparedStatements = this.getPoolPreparedStatements();
        Boolean other$poolPreparedStatements = other.getPoolPreparedStatements();
        if (this$poolPreparedStatements == null ? other$poolPreparedStatements != null : !((Object)this$poolPreparedStatements).equals(other$poolPreparedStatements)) {
            return false;
        }
        Integer this$maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        Integer other$maxPoolPreparedStatementPerConnectionSize = other.getMaxPoolPreparedStatementPerConnectionSize();
        if (this$maxPoolPreparedStatementPerConnectionSize == null ? other$maxPoolPreparedStatementPerConnectionSize != null : !((Object)this$maxPoolPreparedStatementPerConnectionSize).equals(other$maxPoolPreparedStatementPerConnectionSize)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        String this$dataSourceName = this.getDataSourceName();
        String other$dataSourceName = other.getDataSourceName();
        return !(this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        Integer $initialSize = this.getInitialSize();
        result = result * 59 + ($initialSize == null ? 43 : ((Object)$initialSize).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Integer $maxActive = this.getMaxActive();
        result = result * 59 + ($maxActive == null ? 43 : ((Object)$maxActive).hashCode());
        Integer $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Integer $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + ($timeBetweenEvictionRunsMillis == null ? 43 : ((Object)$timeBetweenEvictionRunsMillis).hashCode());
        Integer $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + ($minEvictableIdleTimeMillis == null ? 43 : ((Object)$minEvictableIdleTimeMillis).hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        Boolean $testWhileIdle = this.getTestWhileIdle();
        result = result * 59 + ($testWhileIdle == null ? 43 : ((Object)$testWhileIdle).hashCode());
        Boolean $testOnBorrow = this.getTestOnBorrow();
        result = result * 59 + ($testOnBorrow == null ? 43 : ((Object)$testOnBorrow).hashCode());
        Boolean $testOnReturn = this.getTestOnReturn();
        result = result * 59 + ($testOnReturn == null ? 43 : ((Object)$testOnReturn).hashCode());
        Boolean $poolPreparedStatements = this.getPoolPreparedStatements();
        result = result * 59 + ($poolPreparedStatements == null ? 43 : ((Object)$poolPreparedStatements).hashCode());
        Integer $maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        result = result * 59 + ($maxPoolPreparedStatementPerConnectionSize == null ? 43 : ((Object)$maxPoolPreparedStatementPerConnectionSize).hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        String $dataSourceName = this.getDataSourceName();
        result = result * 59 + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
        return result;
    }

    public String toString() {
        return "DruidProperties(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", initialSize=" + this.getInitialSize() + ", minIdle=" + this.getMinIdle() + ", maxActive=" + this.getMaxActive() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", validationQuery=" + this.getValidationQuery() + ", testWhileIdle=" + this.getTestWhileIdle() + ", testOnBorrow=" + this.getTestOnBorrow() + ", testOnReturn=" + this.getTestOnReturn() + ", poolPreparedStatements=" + this.getPoolPreparedStatements() + ", maxPoolPreparedStatementPerConnectionSize=" + this.getMaxPoolPreparedStatementPerConnectionSize() + ", filters=" + this.getFilters() + ", dataSourceName=" + this.getDataSourceName() + ")";
    }
}

