/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.db;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.exception.enums.CoreExceptionEnum;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbInitializer {
    private static final Logger log = LoggerFactory.getLogger(DbInitializer.class);
    private Boolean fieldValidatorExceptionFlag = true;

    public DbInitializer() {
    }

    public DbInitializer(Boolean fieldValidatorExceptionFlag) {
        this.fieldValidatorExceptionFlag = fieldValidatorExceptionFlag;
    }

    public void dbInit() {
        this.initTable();
        this.fieldsValidate();
    }

    private void initTable() {
        String tableInitSql;
        String tableName = this.getTableName();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{tableName, tableInitSql = this.getTableInitSql()}) && this.fieldValidatorExceptionFlag.booleanValue()) {
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.INIT_TABLE_EMPTY_PARAMS);
        }
        List tableLists = SqlRunner.db().selectObjs("SHOW TABLES", new Object[0]);
        if (!tableLists.contains(tableName.toUpperCase()) && !tableLists.contains(tableName.toLowerCase())) {
            SqlRunner.db().update(tableInitSql, new Object[0]);
            log.info("\u521d\u59cb\u5316" + this.getTableName() + "\u6210\u529f\uff01");
        }
    }

    private void fieldsValidate() {
        String sql = this.showColumnsSql();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{sql}) && this.fieldValidatorExceptionFlag.booleanValue()) {
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.INIT_TABLE_EMPTY_PARAMS);
        }
        List tableFields = SqlRunner.db().selectList(sql, new Object[0]);
        if (tableFields != null && !tableFields.isEmpty()) {
            ArrayList<String> fieldsNotInClass = new ArrayList<String>();
            List<String> classFields = this.getClassFields();
            for (Map tableField : tableFields) {
                String fieldName = (String)tableField.get("Field");
                if (classFields.contains(fieldName.toLowerCase())) continue;
                fieldsNotInClass.add(fieldName);
            }
            if (!fieldsNotInClass.isEmpty()) {
                log.error("\u5b9e\u4f53\u4e2d\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u4e0d\u4e00\u81f4\u7684\u5b57\u6bb5\u5982\u4e0b\uff1a" + JSON.toJSONString(fieldsNotInClass));
                if (this.fieldValidatorExceptionFlag.booleanValue()) {
                    throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FIELD_VALIDATE_ERROR);
                }
            }
        }
    }

    private List<String> getClassFields() {
        Class<?> entityClass = this.getEntityClass();
        Field[] declaredFields = ClassUtil.getDeclaredFields(entityClass);
        ArrayList<String> filedNamesUnderlineCase = new ArrayList<String>();
        for (Field declaredField : declaredFields) {
            String fieldName = StrUtil.toUnderlineCase((CharSequence)declaredField.getName());
            filedNamesUnderlineCase.add(fieldName);
        }
        return filedNamesUnderlineCase;
    }

    private String showColumnsSql() {
        return "SHOW COLUMNS FROM " + this.getTableName();
    }

    protected abstract String getTableInitSql();

    protected abstract String getTableName();

    protected abstract Class<?> getEntityClass();

    public Boolean getFieldValidatorExceptionFlag() {
        return this.fieldValidatorExceptionFlag;
    }

    public void setFieldValidatorExceptionFlag(Boolean fieldValidatorExceptionFlag) {
        this.fieldValidatorExceptionFlag = fieldValidatorExceptionFlag;
    }
}

