/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.api.enums.FileStatusEnum;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.AntdvFileInfo;
import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.api.util.DownloadUtil;
import cn.stylefeng.roses.kernel.file.api.util.PdfFileTypeUtil;
import cn.stylefeng.roses.kernel.file.api.util.PicFileTypeUtil;
import cn.stylefeng.roses.kernel.file.api.util.SvgFileTypeUtil;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileStorage;
import cn.stylefeng.roses.kernel.file.modular.factory.FileInfoFactory;
import cn.stylefeng.roses.kernel.file.modular.mapper.SysFileInfoMapper;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileInfoService;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileStorageService;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.StrFilterUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysFileInfoServiceImpl
extends ServiceImpl<SysFileInfoMapper, SysFileInfo>
implements SysFileInfoService {
    private static final Logger log = LoggerFactory.getLogger(SysFileInfoServiceImpl.class);
    @Resource
    private FileOperatorApi fileOperatorApi;
    @Resource
    private SysFileStorageService sysFileStorageService;

    @Override
    public SysFileInfoResponse getFileInfoResult(Long fileId) {
        byte[] fileBytes;
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        try {
            SysFileStorage storage;
            fileBytes = FileLocationEnum.DB.getCode().equals(sysFileInfo.getFileLocation()) ? ((storage = (SysFileStorage)this.sysFileStorageService.getById(fileId)) == null ? ResourceUtil.readBytes((String)("pics/" + sysFileInfo.getFileId() + "." + sysFileInfo.getFileSuffix())) : storage.getFileBytes()) : this.fileOperatorApi.getFileBytes(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR, new Object[]{e.getMessage()});
        }
        SysFileInfoResponse sysFileInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)sysFileInfoResult, (String[])new String[0]);
        sysFileInfoResult.setFileBytes(fileBytes);
        return sysFileInfoResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFileInfoResponse uploadFile(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = FileInfoFactory.createSysFileInfo(file, sysFileInfoRequest);
        this.save((Object)sysFileInfo);
        try {
            byte[] bytes = file.getBytes();
            if (FileLocationEnum.DB.getCode().equals(sysFileInfoRequest.getFileLocation())) {
                this.sysFileStorageService.saveFile(sysFileInfo.getFileId(), bytes);
            } else {
                this.fileOperatorApi.storageFile(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName(), bytes);
            }
        }
        catch (IOException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ERROR_FILE, new Object[]{e.getMessage()});
        }
        SysFileInfoResponse fileUploadInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)fileUploadInfoResult, (String[])new String[0]);
        String fileAuthUrl = YesOrNotEnum.Y.getCode().equals(sysFileInfoRequest.getSecretFlag()) ? this.fileOperatorApi.getFileAuthUrl(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName(), Long.valueOf(FileConfigExpander.getDefaultFileTimeoutSeconds() * 1000L)) : this.fileOperatorApi.getFileUnAuthUrl(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName());
        fileUploadInfoResult.setFileUrl(fileAuthUrl);
        return fileUploadInfoResult;
    }

    @Override
    public SysFileInfoResponse updateFile(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        Long fileCode = sysFileInfoRequest.getFileCode();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFileCode, (Object)fileCode);
        queryWrapper.eq(SysFileInfo::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.eq(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        SysFileInfo oldFileInfo = (SysFileInfo)((Object)this.getOne((Wrapper)queryWrapper));
        if (ObjectUtil.isEmpty((Object)((Object)oldFileInfo))) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.NOT_EXISTED);
        }
        oldFileInfo.setFileStatus(FileStatusEnum.OLD.getCode());
        this.updateById((Object)oldFileInfo);
        SysFileInfo newFileInfo = FileInfoFactory.createSysFileInfo(file, sysFileInfoRequest);
        newFileInfo.setFileCode(fileCode);
        newFileInfo.setFileVersion(oldFileInfo.getFileVersion() + 1);
        this.save((Object)newFileInfo);
        SysFileInfoResponse fileUploadInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)newFileInfo), (Object)fileUploadInfoResult, (String[])new String[0]);
        return fileUploadInfoResult;
    }

    @Override
    public void download(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        SysFileInfoResponse sysFileInfoResponse = this.getFileInfoResult(sysFileInfoRequest.getFileId());
        if (YesOrNotEnum.Y.getCode().equals(sysFileInfoResponse.getSecretFlag()) && YesOrNotEnum.N.getCode().equals(sysFileInfoRequest.getSecretFlag())) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_DENIED_ACCESS);
        }
        DownloadUtil.download((String)sysFileInfoResponse.getFileOriginName(), (byte[])sysFileInfoResponse.getFileBytes(), (HttpServletResponse)response);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteReally(SysFileInfoRequest sysFileInfoRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysFileInfo::getFileId, (Object)sysFileInfoRequest.getFileId());
        if (ObjectUtil.isNotEmpty((Object)sysFileInfoRequest.getFileCode())) {
            ((LambdaQueryWrapper)wrapper.or()).eq(SysFileInfo::getFileCode, (Object)sysFileInfoRequest.getFileCode());
        }
        List fileInfos = this.list((Wrapper)wrapper);
        this.removeByIds(fileInfos.stream().map(SysFileInfo::getFileId).collect(Collectors.toList()));
        for (SysFileInfo fileInfo : fileInfos) {
            if (fileInfo.getFileLocation().equals(FileLocationEnum.DB.getCode())) {
                this.sysFileStorageService.removeById(fileInfo.getFileId());
                continue;
            }
            this.fileOperatorApi.deleteFile(fileInfo.getFileBucket(), fileInfo.getFileObjectName());
        }
    }

    @Override
    public PageResult<SysFileInfo> fileInfoListPage(SysFileInfoRequest sysFileInfoRequest) {
        LambdaQueryWrapper fileWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)sysFileInfoRequest.getFileOriginName())) {
            fileWrapper.like(SysFileInfo::getFileOriginName, (Object)sysFileInfoRequest.getFileOriginName());
        }
        if (ObjectUtil.isNotEmpty((Object)sysFileInfoRequest.getFileLocation())) {
            fileWrapper.eq(SysFileInfo::getFileLocation, (Object)sysFileInfoRequest.getFileLocation());
        }
        fileWrapper.select(new SFunction[]{SysFileInfo::getFileId, SysFileInfo::getFileCode, SysFileInfo::getSecretFlag, SysFileInfo::getFileBucket, SysFileInfo::getFileObjectName, SysFileInfo::getFileLocation, SysFileInfo::getFileOriginName, SysFileInfo::getFileSuffix, SysFileInfo::getFileSizeInfo, SysFileInfo::getFileVersion, BaseEntity::getCreateTime});
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)fileWrapper);
        List records = page.getRecords();
        List newList = records.stream().filter(i -> !i.getFileOriginName().equals("defaultAvatar.png")).collect(Collectors.toList());
        for (SysFileInfo sysFileInfo : newList) {
            if (!PicFileTypeUtil.getFileImgTypeFlag((String)sysFileInfo.getFileSuffix())) continue;
            sysFileInfo.setFileUrl(this.getFileAuthUrl(sysFileInfo.getFileId()));
        }
        return PageResultFactory.createPageResult((Page)page.setRecords(newList));
    }

    @Override
    public void packagingDownload(String fileIds, String secretFlag, HttpServletResponse response) {
        List<Long> fileIdList = Arrays.stream(fileIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<SysFileInfoResponse> fileInfoResponseList = this.getFileInfoListByFileIds(fileIdList);
        String bucketName = FileConfigExpander.getDefaultBucket();
        if (ObjectUtil.isNotEmpty(fileInfoResponseList)) {
            bucketName = fileInfoResponseList.get(0).getFileBucket();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        try {
            for (int i = 0; i < fileInfoResponseList.size(); ++i) {
                SysFileInfoResponse sysFileInfoResponse = fileInfoResponseList.get(i);
                if (!ObjectUtil.isNotEmpty((Object)sysFileInfoResponse)) continue;
                String fileOriginName = sysFileInfoResponse.getFileOriginName();
                if (secretFlag.equals(YesOrNotEnum.N.getCode()) && !secretFlag.equals(sysFileInfoResponse.getSecretFlag())) {
                    throw new FileException((AbstractExceptionEnum)FileExceptionEnum.SECRET_FLAG_INFO_ERROR, new Object[]{fileOriginName});
                }
                byte[] fileBytes = this.fileOperatorApi.getFileBytes(bucketName, sysFileInfoResponse.getFileObjectName());
                ZipEntry entry = new ZipEntry(i + 1 + "." + fileOriginName);
                entry.setSize(fileBytes.length);
                zip.putNextEntry(entry);
                zip.write(fileBytes);
            }
            zip.finish();
            DownloadUtil.download((String)(DateUtil.now() + "-\u6253\u5305\u4e0b\u8f7d" + "." + "zip"), (byte[])bos.toByteArray(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            try {
                zip.closeEntry();
                zip.close();
                bos.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6570\u636e\u6d41\u5931\u8d25\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<SysFileInfoResponse> getFileInfoListByFileIds(String fileIds) {
        List<Long> fileIdList = Arrays.stream(fileIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.getFileInfoListByFileIds(fileIdList);
    }

    @Override
    public void preview(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        SysFileInfoResponse sysFileInfoResponse = this.getFileInfoResult(sysFileInfoRequest.getFileId());
        if (YesOrNotEnum.Y.getCode().equals(sysFileInfoResponse.getSecretFlag()) && YesOrNotEnum.N.getCode().equals(sysFileInfoRequest.getSecretFlag())) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_DENIED_ACCESS);
        }
        String fileSuffix = sysFileInfoResponse.getFileSuffix().toLowerCase();
        byte[] fileBytes = sysFileInfoResponse.getFileBytes();
        this.renderPreviewFile(response, fileSuffix, fileBytes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFileInfoResponse versionBack(SysFileInfoRequest sysFileInfoRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFileId, (Object)sysFileInfoRequest.getFileId());
        SysFileInfo fileInfo = (SysFileInfo)((Object)this.getOne((Wrapper)queryWrapper));
        if (ObjectUtil.isEmpty((Object)((Object)fileInfo))) {
            String userTip = FileExceptionEnum.FILE_NOT_FOUND.getUserTip();
            String errorMessage = StrUtil.format((CharSequence)userTip, (Object[])new Object[]{"\u6587\u4ef6:" + fileInfo.getFileId() + "\u672a\u627e\u5230\uff01"});
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND, new Object[]{errorMessage});
        }
        LambdaUpdateWrapper oldFileInfoLambdaUpdateWrapper = new LambdaUpdateWrapper();
        oldFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileCode, (Object)fileInfo.getFileCode());
        oldFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        oldFileInfoLambdaUpdateWrapper.set(SysFileInfo::getFileStatus, (Object)FileStatusEnum.OLD.getCode());
        this.update((Wrapper)oldFileInfoLambdaUpdateWrapper);
        LambdaUpdateWrapper newFileInfoLambdaUpdateWrapper = new LambdaUpdateWrapper();
        newFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileId, (Object)sysFileInfoRequest.getFileId());
        newFileInfoLambdaUpdateWrapper.set(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        newFileInfoLambdaUpdateWrapper.set(SysFileInfo::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        this.update((Wrapper)newFileInfoLambdaUpdateWrapper);
        return (SysFileInfoResponse)BeanUtil.toBean((Object)((Object)fileInfo), SysFileInfoResponse.class);
    }

    @Override
    public void previewByBucketAndObjName(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        byte[] fileBytes;
        if (StrUtil.isNotBlank((CharSequence)sysFileInfoRequest.getFileObjectName())) {
            sysFileInfoRequest.setFileObjectName(StrFilterUtil.filterFileName((String)sysFileInfoRequest.getFileObjectName()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysFileInfo::getFileObjectName, (Object)sysFileInfoRequest.getFileObjectName());
        wrapper.eq(SysFileInfo::getSecretFlag, (Object)YesOrNotEnum.Y.getCode());
        long count = this.count((Wrapper)wrapper);
        if (count > 0L && !LoginContext.me().hasLogin()) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_PERMISSION_DENIED);
        }
        try {
            fileBytes = this.fileOperatorApi.getFileBytes(sysFileInfoRequest.getFileBucket(), sysFileInfoRequest.getFileObjectName());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR, new Object[]{e.getMessage()});
        }
        String fileSuffix = FileUtil.getSuffix((String)sysFileInfoRequest.getFileObjectName());
        this.renderPreviewFile(response, fileSuffix, fileBytes);
    }

    @Override
    public SysFileInfo detail(SysFileInfoRequest sysFileInfoRequest) {
        return this.querySysFileInfo(sysFileInfoRequest);
    }

    @Override
    public List<SysFileInfoResponse> getFileInfoListByFileIds(List<Long> fileIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysFileInfo::getFileId, fileIdList);
        List list = this.list((Wrapper)wrapper);
        return list.stream().map(i -> {
            SysFileInfoResponse sysFileInfoResponse = new SysFileInfoResponse();
            BeanUtil.copyProperties((Object)i, (Object)sysFileInfoResponse, (String[])new String[0]);
            return sysFileInfoResponse;
        }).collect(Collectors.toList());
    }

    public SysFileInfoResponse getFileInfoWithoutContent(Long fileId) {
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        SysFileInfoResponse sysFileInfoResponse = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)sysFileInfoResponse, (String[])new String[0]);
        return sysFileInfoResponse;
    }

    public String getFileAuthUrl(Long fileId) {
        return this.getFileAuthUrl(fileId, LoginContext.me().getToken());
    }

    public String getFileAuthUrl(Long fileId, String token) {
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        if (sysFileInfo.getFileLocation().equals(FileLocationEnum.DB.getCode())) {
            return this.sysFileStorageService.getFileAuthUrl(String.valueOf(fileId));
        }
        return this.fileOperatorApi.getFileAuthUrl(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName(), FileConfigExpander.getDefaultFileTimeoutSeconds());
    }

    public String getFileUnAuthUrl(Long fileId) {
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        if (sysFileInfo.getFileLocation().equals(FileLocationEnum.DB.getCode())) {
            return this.sysFileStorageService.getFileUnAuthUrl(String.valueOf(fileId));
        }
        return this.fileOperatorApi.getFileUnAuthUrl(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName());
    }

    public AntdvFileInfo buildAntdvFileInfo(Long fileId) {
        AntdvFileInfo antdvFileInfo = new AntdvFileInfo();
        antdvFileInfo.setUid(IdWorker.getIdStr());
        try {
            SysFileInfoResponse fileInfoWithoutContent = this.getFileInfoWithoutContent(fileId);
            antdvFileInfo.setName(fileInfoWithoutContent.getFileOriginName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String fileAuthUrl = this.getFileAuthUrl(fileId);
        antdvFileInfo.setThumbUrl(fileAuthUrl);
        return antdvFileInfo;
    }

    public void removeFile(Long fileId) {
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        this.deleteReally(sysFileInfoRequest);
    }

    public SysFileInfoResponse uploadFileAndSave(File file, SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = FileInfoFactory.createSysFileInfo(file, sysFileInfoRequest);
        this.save((Object)sysFileInfo);
        try {
            this.fileOperatorApi.storageFile(sysFileInfo.getFileBucket(), sysFileInfo.getFileObjectName(), (InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            log.warn("\u4fdd\u5b58\u6587\u4ef6\u5230storage\u4e2d\u51fa\u9519!", (Throwable)e);
        }
        SysFileInfoResponse fileUploadInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)fileUploadInfoResult, (String[])new String[0]);
        return fileUploadInfoResult;
    }

    private void renderPreviewFile(HttpServletResponse response, String fileSuffix, byte[] fileBytes) {
        if (PicFileTypeUtil.getFileImgTypeFlag((String)fileSuffix) || PdfFileTypeUtil.getFilePdfTypeFlag((String)fileSuffix) || SvgFileTypeUtil.getFileSvgTypeFlag((String)fileSuffix)) {
            try {
                if (PicFileTypeUtil.getFileImgTypeFlag((String)fileSuffix)) {
                    response.setContentType("image/png");
                } else if (PdfFileTypeUtil.getFilePdfTypeFlag((String)fileSuffix)) {
                    response.setContentType("application/pdf");
                } else if (SvgFileTypeUtil.getFileSvgTypeFlag((String)fileSuffix)) {
                    response.setContentType("image/svg+xml");
                }
                ServletOutputStream outputStream = response.getOutputStream();
                IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])fileBytes);
            }
            catch (IOException e) {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.WRITE_BYTES_ERROR, new Object[]{e.getMessage()});
            }
        } else {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.PREVIEW_ERROR_NOT_SUPPORT);
        }
    }

    private SysFileInfo querySysFileInfo(SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = (SysFileInfo)((Object)this.getById(sysFileInfoRequest.getFileId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysFileInfo))) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.NOT_EXISTED, new Object[]{sysFileInfoRequest.getFileId()});
        }
        return sysFileInfo;
    }
}

