/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.constants.FileConstants;
import cn.stylefeng.roses.kernel.file.api.enums.FileStatusEnum;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoListResponse;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.api.util.DownloadUtil;
import cn.stylefeng.roses.kernel.file.api.util.PdfFileTypeUtil;
import cn.stylefeng.roses.kernel.file.api.util.PicFileTypeUtil;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import cn.stylefeng.roses.kernel.file.modular.factory.FileInfoFactory;
import cn.stylefeng.roses.kernel.file.modular.mapper.SysFileInfoMapper;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileInfoService;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysFileInfoServiceImpl
extends ServiceImpl<SysFileInfoMapper, SysFileInfo>
implements SysFileInfoService,
FileInfoApi {
    private static final Logger log = LoggerFactory.getLogger(SysFileInfoServiceImpl.class);
    @Resource
    private FileOperatorApi fileOperatorApi;

    @Override
    public SysFileInfoResponse getFileInfoResult(Long fileId) {
        byte[] fileBytes;
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        try {
            fileBytes = this.fileOperatorApi.getFileBytes("defaultBucket", sysFileInfo.getFileObjectName());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR);
        }
        SysFileInfoResponse sysFileInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)sysFileInfoResult, (String[])new String[0]);
        sysFileInfoResult.setFileBytes(fileBytes);
        return sysFileInfoResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFileInfoResponse uploadFile(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = FileInfoFactory.createSysFileInfo(file, sysFileInfoRequest);
        sysFileInfo.setFileVersion(1);
        sysFileInfo.setFileCode(IdWorker.getId());
        this.save((Object)sysFileInfo);
        SysFileInfoResponse fileUploadInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)fileUploadInfoResult, (String[])new String[0]);
        return fileUploadInfoResult;
    }

    @Override
    public SysFileInfoResponse updateFile(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        Long fileCode = sysFileInfoRequest.getFileCode();
        SysFileInfo sysFileInfo = FileInfoFactory.createSysFileInfo(file, sysFileInfoRequest);
        sysFileInfo.setDelFlag(YesOrNotEnum.Y.getCode());
        sysFileInfo.setFileCode(fileCode);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFileCode, (Object)fileCode);
        queryWrapper.eq(SysFileInfo::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.eq(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        SysFileInfo fileInfo = (SysFileInfo)((Object)this.getOne((Wrapper)queryWrapper));
        if (ObjectUtil.isEmpty((Object)((Object)fileInfo))) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.NOT_EXISTED);
        }
        sysFileInfo.setFileVersion(fileInfo.getFileVersion() + 1);
        this.save((Object)sysFileInfo);
        SysFileInfoResponse fileUploadInfoResult = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)fileUploadInfoResult, (String[])new String[0]);
        return fileUploadInfoResult;
    }

    @Override
    public void download(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        SysFileInfoResponse sysFileInfoResponse = this.getFileInfoResult(sysFileInfoRequest.getFileId());
        if (!sysFileInfoRequest.getSecretFlag().equals(sysFileInfoResponse.getSecretFlag())) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_DENIED_ACCESS);
        }
        DownloadUtil.download((String)sysFileInfoResponse.getFileOriginName(), (byte[])sysFileInfoResponse.getFileBytes(), (HttpServletResponse)response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteReally(SysFileInfoRequest sysFileInfoRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(SysFileInfo::getFileCode, (Object)sysFileInfoRequest.getFileCode());
        List fileInfos = this.list((Wrapper)lqw);
        this.removeByIds(fileInfos.stream().map(SysFileInfo::getFileId).collect(Collectors.toList()));
        for (SysFileInfo fileInfo : fileInfos) {
            this.fileOperatorApi.deleteFile(fileInfo.getFileBucket(), fileInfo.getFileObjectName());
        }
    }

    @Override
    public PageResult<SysFileInfoListResponse> fileInfoListPage(SysFileInfoRequest sysFileInfoRequest) {
        Page page = PageFactory.defaultPage();
        List<SysFileInfoListResponse> list = ((SysFileInfoMapper)this.baseMapper).fileInfoList((Page<SysFileInfoListResponse>)page, sysFileInfoRequest);
        return PageResultFactory.createPageResult((Page)page.setRecords(list));
    }

    @Override
    public void packagingDownload(String fileIds, String secretFlag, HttpServletResponse response) {
        List<Long> fileIdList = Arrays.stream(fileIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<SysFileInfoResponse> fileInfoResponseList = ((SysFileInfoMapper)this.baseMapper).getFileInfoListByFileIds(fileIdList);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        try {
            for (int i = 0; i < fileInfoResponseList.size(); ++i) {
                SysFileInfoResponse sysFileInfoResponse = fileInfoResponseList.get(i);
                if (!ObjectUtil.isNotEmpty((Object)sysFileInfoResponse)) continue;
                String fileOriginName = sysFileInfoResponse.getFileOriginName();
                if (secretFlag.equals(YesOrNotEnum.N.getCode()) && !secretFlag.equals(sysFileInfoResponse.getSecretFlag())) {
                    throw new FileException((AbstractExceptionEnum)FileExceptionEnum.SECRET_FLAG_INFO_ERROR, new Object[]{fileOriginName});
                }
                byte[] fileBytes = this.fileOperatorApi.getFileBytes("defaultBucket", sysFileInfoResponse.getFileObjectName());
                ZipEntry entry = new ZipEntry(i + 1 + "." + fileOriginName);
                entry.setSize(fileBytes.length);
                zip.putNextEntry(entry);
                zip.write(fileBytes);
            }
            zip.finish();
            DownloadUtil.download((String)(DateUtil.now() + "-\u6253\u5305\u4e0b\u8f7d" + "." + "zip"), (byte[])bos.toByteArray(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR);
        }
        finally {
            try {
                zip.closeEntry();
                zip.close();
                bos.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6570\u636e\u6d41\u5931\u8d25\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<SysFileInfoResponse> getFileInfoListByFileIds(String fileIds) {
        List<Long> fileIdList = Arrays.stream(fileIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return ((SysFileInfoMapper)this.baseMapper).getFileInfoListByFileIds(fileIdList);
    }

    @Override
    public void preview(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        if (FileConstants.DEFAULT_AVATAR_FILE_ID.equals(sysFileInfoRequest.getFileId())) {
            DownloadUtil.renderPreviewFile((HttpServletResponse)response, (byte[])Base64.decode((CharSequence)FileConfigExpander.getDefaultAvatarBase64()));
            return;
        }
        SysFileInfoResponse sysFileInfoResponse = this.getFileInfoResult(sysFileInfoRequest.getFileId());
        if (!sysFileInfoRequest.getSecretFlag().equals(sysFileInfoResponse.getSecretFlag())) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_DENIED_ACCESS);
        }
        String fileSuffix = sysFileInfoResponse.getFileSuffix().toLowerCase();
        byte[] fileBytes = sysFileInfoResponse.getFileBytes();
        this.renderPreviewFile(response, fileSuffix, fileBytes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmReplaceFile(List<Long> fileIdList) {
        if (fileIdList == null || fileIdList.size() == 0) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_IDS_EMPTY);
        }
        List<Long> fileCodeList = ((SysFileInfoMapper)this.baseMapper).getFileCodeByFileIds(fileIdList);
        if (fileCodeList == null || fileCodeList.size() == 0) {
            return;
        }
        ((SysFileInfoMapper)this.baseMapper).updateDelFlagByFileCodes(fileCodeList, YesOrNotEnum.Y.getCode());
        ((SysFileInfoMapper)this.baseMapper).updateDelFlagByFileIds(fileIdList, YesOrNotEnum.N.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFileInfoResponse versionBack(SysFileInfoRequest sysFileInfoRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFileId, (Object)sysFileInfoRequest.getFileId());
        SysFileInfo fileInfo = (SysFileInfo)((Object)this.getOne((Wrapper)queryWrapper));
        if (ObjectUtil.isEmpty((Object)((Object)fileInfo))) {
            String userTip = FileExceptionEnum.FILE_NOT_FOUND.getUserTip();
            String errorMessage = StrUtil.format((CharSequence)userTip, (Object[])new Object[]{"\u6587\u4ef6:" + fileInfo.getFileId() + "\u672a\u627e\u5230\uff01"});
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND, new Object[]{errorMessage});
        }
        LambdaUpdateWrapper oldFileInfoLambdaUpdateWrapper = new LambdaUpdateWrapper();
        oldFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileCode, (Object)fileInfo.getFileCode());
        oldFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        oldFileInfoLambdaUpdateWrapper.set(SysFileInfo::getFileStatus, (Object)FileStatusEnum.OLD.getCode());
        this.update((Wrapper)oldFileInfoLambdaUpdateWrapper);
        LambdaUpdateWrapper newFileInfoLambdaUpdateWrapper = new LambdaUpdateWrapper();
        newFileInfoLambdaUpdateWrapper.eq(SysFileInfo::getFileId, (Object)sysFileInfoRequest.getFileId());
        newFileInfoLambdaUpdateWrapper.set(SysFileInfo::getFileStatus, (Object)FileStatusEnum.NEW.getCode());
        newFileInfoLambdaUpdateWrapper.set(SysFileInfo::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        this.update((Wrapper)newFileInfoLambdaUpdateWrapper);
        return (SysFileInfoResponse)BeanUtil.toBean((Object)((Object)fileInfo), SysFileInfoResponse.class);
    }

    @Override
    public void previewByBucketAndObjName(SysFileInfoRequest sysFileInfoRequest, HttpServletResponse response) {
        byte[] fileBytes;
        try {
            fileBytes = this.fileOperatorApi.getFileBytes(sysFileInfoRequest.getFileBucket(), sysFileInfoRequest.getFileObjectName());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_STREAM_ERROR);
        }
        String fileSuffix = FileUtil.getSuffix((String)sysFileInfoRequest.getFileObjectName());
        this.renderPreviewFile(response, fileSuffix, fileBytes);
    }

    @Override
    public SysFileInfo detail(SysFileInfoRequest sysFileInfoRequest) {
        return this.querySysFileInfo(sysFileInfoRequest);
    }

    public SysFileInfoResponse getFileInfoWithoutContent(Long fileId) {
        SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
        sysFileInfoRequest.setFileId(fileId);
        SysFileInfo sysFileInfo = this.querySysFileInfo(sysFileInfoRequest);
        SysFileInfoResponse sysFileInfoResponse = new SysFileInfoResponse();
        BeanUtil.copyProperties((Object)((Object)sysFileInfo), (Object)sysFileInfoResponse, (String[])new String[0]);
        return sysFileInfoResponse;
    }

    public String getFileAuthUrl(Long fileId) {
        String token = LoginContext.me().getToken();
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        return FileConfigExpander.getServerDeployHost() + contextPath + "/sysFileInfo/private/preview" + "?fileId=" + fileId + "&token=" + token;
    }

    public String getFileAuthUrl(Long fileId, String token) {
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        return FileConfigExpander.getServerDeployHost() + contextPath + "/sysFileInfo/private/preview" + "?fileId=" + fileId + "&token=" + token;
    }

    private void renderPreviewFile(HttpServletResponse response, String fileSuffix, byte[] fileBytes) {
        if (PicFileTypeUtil.getFileImgTypeFlag((String)fileSuffix) || PdfFileTypeUtil.getFilePdfTypeFlag((String)fileSuffix)) {
            try {
                if (PicFileTypeUtil.getFileImgTypeFlag((String)fileSuffix)) {
                    response.setContentType("image/png");
                } else if (PdfFileTypeUtil.getFilePdfTypeFlag((String)fileSuffix)) {
                    response.setContentType("application/pdf");
                }
                ServletOutputStream outputStream = response.getOutputStream();
                IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])fileBytes);
            }
            catch (IOException e) {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.WRITE_BYTES_ERROR, new Object[]{e.getMessage()});
            }
        } else {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.PREVIEW_ERROR_NOT_SUPPORT);
        }
    }

    private SysFileInfo querySysFileInfo(SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = (SysFileInfo)((Object)this.getById(sysFileInfoRequest.getFileId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysFileInfo)) || sysFileInfo.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.NOT_EXISTED, new Object[]{sysFileInfoRequest.getFileId()});
        }
        return sysFileInfo;
    }
}

