/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.controller;

import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileInfoService;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ApiResource(name="\u6587\u4ef6\u4fe1\u606f\u76f8\u5173\u63a5\u53e3")
public class SysFileInfoController {
    @Resource
    private SysFileInfoService sysFileInfoService;

    @PostResource(name="\u4e0a\u4f20\u6587\u4ef6", path={"/sysFileInfo/upload"}, requiredPermission=false)
    public ResponseData upload(@RequestPart(value="file") MultipartFile file, @Validated(value={BaseRequest.add.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.uploadFile(file, sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @PostResource(name="\u4e0a\u4f20\u6587\u4ef6", path={"/sysFileInfo/tinymceUpload"}, requiredPermission=false)
    public Map<String, String> tinymceUpload(@RequestPart(value="file") MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1);
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.uploadFile(file, sysFileInfoRequest);
        resultMap.put("location", "/sysFileInfo/public/preview?fileId=" + fileUploadInfoResult.getFileId());
        return resultMap;
    }

    @GetResource(name="\u79c1\u6709\u6587\u4ef6\u9884\u89c8", path={"/sysFileInfo/private/preview"}, requiredPermission=false)
    public void privatePreview(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.Y.getCode());
        this.sysFileInfoService.preview(sysFileInfoRequest, response);
    }

    @GetResource(name="\u516c\u6709\u6587\u4ef6\u9884\u89c8", path={"/sysFileInfo/public/preview"}, requiredPermission=false, requiredLogin=false)
    public void publicPreview(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        this.sysFileInfoService.preview(sysFileInfoRequest, response);
    }

    @GetResource(name="\u6587\u4ef6\u9884\u89c8\uff0c\u901a\u8fc7bucketName\u548cobjectName", path={"/sysFileInfo/previewByObjectName"}, requiredPermission=false)
    public void previewByBucketNameObjectName(@Validated(value={SysFileInfoRequest.previewByObjectName.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.previewByBucketAndObjName(sysFileInfoRequest, response);
    }

    @GetResource(name="\u79c1\u6709\u6587\u4ef6\u4e0b\u8f7d", path={"/sysFileInfo/privateDownload"}, requiredPermission=false)
    public void privateDownload(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.Y.getCode());
        this.sysFileInfoService.download(sysFileInfoRequest, response);
    }

    @GetResource(name="\u516c\u6709\u6587\u4ef6\u4e0b\u8f7d", path={"/sysFileInfo/publicDownload"}, requiredLogin=false, requiredPermission=false)
    public void publicDownload(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        this.sysFileInfoService.download(sysFileInfoRequest, response);
    }

    @PostResource(name="\u66ff\u6362\u6587\u4ef6", path={"/sysFileInfo/update"}, requiredPermission=false)
    public ResponseData update(@RequestPart(value="file") MultipartFile file, @Validated(value={BaseRequest.edit.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.updateFile(file, sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @PostResource(name="\u66ff\u6362\u6587\u4ef6", path={"/sysFileInfo/versionBack"}, requiredPermission=false)
    public ResponseData versionBack(@Validated(value={SysFileInfoRequest.versionBack.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.versionBack(sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @GetResource(name="\u6839\u636e\u9644\u4ef6IDS\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", path={"/sysFileInfo/getFileInfoListByFileIds"}, requiredPermission=false)
    public ResponseData getFileInfoListByFileIds(@RequestParam(value="fileIds") String fileIds) {
        List<SysFileInfoResponse> list = this.sysFileInfoService.getFileInfoListByFileIds(fileIds);
        return new SuccessResponseData(list);
    }

    @GetResource(name="\u516c\u6709\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6", path={"/sysFileInfo/publicPackagingDownload"}, requiredPermission=false, requiredLogin=false)
    public void publicPackagingDownload(@RequestParam(value="fileIds") String fileIds) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.packagingDownload(fileIds, YesOrNotEnum.N.getCode(), response);
    }

    @GetResource(name="\u79c1\u6709\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6", path={"/sysFileInfo/privatePackagingDownload"}, requiredPermission=false)
    public void privatePackagingDownload(@RequestParam(value="fileIds") String fileIds) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.packagingDownload(fileIds, YesOrNotEnum.Y.getCode(), response);
    }

    @PostResource(name="\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff08\u771f\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff09", path={"/sysFileInfo/deleteReally"}, requiredPermission=false)
    public ResponseData deleteReally(@RequestBody @Validated(value={BaseRequest.delete.class}) SysFileInfoRequest sysFileInfoRequest) {
        this.sysFileInfoService.deleteReally(sysFileInfoRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u5206\u9875\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u8868", path={"/sysFileInfo/fileInfoListPage"}, requiredPermission=false)
    public ResponseData fileInfoListPage(SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData(this.sysFileInfoService.fileInfoListPage(sysFileInfoRequest));
    }

    @PostResource(name="\u786e\u8ba4\u66ff\u6362\u9644\u4ef6", path={"/sysFileInfo/confirmReplaceFile"}, requiredPermission=false)
    public ResponseData confirmReplaceFile(@RequestBody List<Long> fileIdList) {
        this.sysFileInfoService.confirmReplaceFile(fileIdList);
        return new SuccessResponseData();
    }

    @GetResource(name="\u67e5\u770b\u8be6\u60c5\u6587\u4ef6\u4fe1\u606f\u8868", path={"/sysFileInfo/detail"}, requiredPermission=false)
    public ResponseData detail(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData((Object)this.sysFileInfoService.detail(sysFileInfoRequest));
    }
}

