/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.email;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import cn.stylefeng.roses.kernel.email.api.MailSenderApi;
import cn.stylefeng.roses.kernel.email.api.exception.MailException;
import cn.stylefeng.roses.kernel.email.api.exception.enums.EmailExceptionEnum;
import cn.stylefeng.roses.kernel.email.api.pojo.SendMailParam;
import java.io.File;
import java.util.Collection;

public class JavaMailSender
implements MailSenderApi {
    private final MailAccount mailAccount;

    public JavaMailSender(MailAccount mailAccount) {
        this.mailAccount = mailAccount;
    }

    public void sendMail(SendMailParam sendMailParam) {
        this.assertSendMailParams(sendMailParam);
        MailUtil.send((MailAccount)this.mailAccount, (Collection)CollUtil.newArrayList((Object[])new String[]{sendMailParam.getTo()}), (String)sendMailParam.getTitle(), (String)sendMailParam.getContent(), (boolean)false, (File[])new File[0]);
    }

    public void sendMailHtml(SendMailParam sendMailParam) {
        this.assertSendMailParams(sendMailParam);
        MailUtil.send((MailAccount)this.mailAccount, (Collection)CollUtil.newArrayList((Object[])new String[]{sendMailParam.getTo()}), (String)sendMailParam.getTitle(), (String)sendMailParam.getContent(), (boolean)true, (File[])new File[0]);
    }

    private void assertSendMailParams(SendMailParam sendMailParam) {
        if (sendMailParam == null) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{""});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getTo())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u6536\u4ef6\u4eba\u90ae\u7bb1"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getTitle())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u90ae\u4ef6\u6807\u9898"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getContent())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u90ae\u4ef6\u5185\u5bb9"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
    }
}

