/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dsctn.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.DruidDatasourceFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dsctn.api.context.CurrentDataSourceContext;
import cn.stylefeng.roses.kernel.dsctn.api.exception.DatasourceContainerException;
import cn.stylefeng.roses.kernel.dsctn.api.exception.enums.DatasourceContainerExceptionEnum;
import cn.stylefeng.roses.kernel.dsctn.api.pojo.DataBaseInfoDto;
import cn.stylefeng.roses.kernel.dsctn.api.pojo.DataSourceDto;
import cn.stylefeng.roses.kernel.dsctn.api.pojo.request.DatabaseInfoRequest;
import cn.stylefeng.roses.kernel.dsctn.context.DataSourceContext;
import cn.stylefeng.roses.kernel.dsctn.modular.entity.DatabaseInfo;
import cn.stylefeng.roses.kernel.dsctn.modular.factory.DruidPropertiesFactory;
import cn.stylefeng.roses.kernel.dsctn.modular.mapper.DatabaseInfoMapper;
import cn.stylefeng.roses.kernel.dsctn.modular.service.DatabaseInfoService;
import cn.stylefeng.roses.kernel.group.api.GroupApi;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupDTO;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupRequest;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.DatabaseTypeUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatabaseInfoServiceImpl
extends ServiceImpl<DatabaseInfoMapper, DatabaseInfo>
implements DatabaseInfoService {
    @Resource
    private GroupApi groupApi;

    @Transactional(rollbackFor={Exception.class})
    public void add(DatabaseInfoRequest databaseInfoRequest) {
        this.validateConnection(databaseInfoRequest);
        DatabaseInfo entity = new DatabaseInfo();
        BeanUtil.copyProperties((Object)databaseInfoRequest, (Object)((Object)entity), (String[])new String[0]);
        entity.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.addDataSourceToContext(entity, false);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByDatasourceCode(String datasourceCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DatabaseInfo::getDbName, (Object)datasourceCode);
        DatabaseInfo databaseInfo = (DatabaseInfo)((Object)this.getOne((Wrapper)wrapper, false));
        this.removeById(databaseInfo.getDbId());
        DataSourceContext.removeDataSource((String)datasourceCode);
    }

    public List<DataBaseInfoDto> getDatasourceList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{DatabaseInfo::getDbId, DatabaseInfo::getDbName, DatabaseInfo::getRemarks, DatabaseInfo::getJdbcUrl});
        List list = this.list((Wrapper)wrapper);
        return list.stream().map(item -> {
            DataBaseInfoDto dataBaseInfoDto = new DataBaseInfoDto();
            BeanUtil.copyProperties((Object)item, (Object)dataBaseInfoDto, (String[])new String[0]);
            String type = DbTypeEnum.getTypeByUrl((String)item.getJdbcUrl());
            dataBaseInfoDto.setDbType(type);
            return dataBaseInfoDto;
        }).collect(Collectors.toList());
    }

    public DbTypeEnum getCurrentDbType() {
        String dataSourceName = CurrentDataSourceContext.getDataSourceName();
        if (StrUtil.isEmpty((CharSequence)dataSourceName)) {
            return null;
        }
        Map dataSourcesProps = DataSourceContext.getDataSourcesConfs();
        DruidProperties druidProperties = (DruidProperties)dataSourcesProps.get(dataSourceName);
        if (druidProperties == null) {
            return null;
        }
        String url = druidProperties.getUrl();
        if (ObjectUtil.isNotEmpty((Object)url)) {
            return null;
        }
        return DatabaseTypeUtil.getDbType((String)url);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DatabaseInfoRequest databaseInfoRequest) {
        DatabaseInfo databaseInfo = this.queryDatabaseInfoById(databaseInfoRequest);
        if ("master".equals(databaseInfo.getDbName())) {
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.MASTER_DATASOURCE_CANT_DELETE);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(DatabaseInfo::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        updateWrapper.eq(DatabaseInfo::getDbId, (Object)databaseInfoRequest.getDbId());
        this.update((Wrapper)updateWrapper);
        DataSourceContext.removeDataSource((String)databaseInfo.getDbName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(DatabaseInfoRequest databaseInfoRequest) {
        DatabaseInfo databaseInfo = this.queryDatabaseInfoById(databaseInfoRequest);
        if (!databaseInfoRequest.getDbName().equals(databaseInfo.getDbName())) {
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.EDIT_DATASOURCE_NAME_ERROR, new Object[]{databaseInfo.getDbName()});
        }
        this.validateConnection(databaseInfoRequest);
        BeanUtil.copyProperties((Object)databaseInfoRequest, (Object)((Object)databaseInfo), (String[])new String[0]);
        this.updateById((Object)databaseInfo);
        this.addDataSourceToContext(databaseInfo, true);
    }

    @Override
    public PageResult<DatabaseInfo> findPage(DatabaseInfoRequest databaseInfoRequest) {
        LambdaQueryWrapper<DatabaseInfo> queryWrapper = this.createWrapper(databaseInfoRequest);
        Page result = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        SysGroupRequest sysGroupRequest = new SysGroupRequest();
        sysGroupRequest.setGroupBizCode("DATASOURCE");
        List list = this.groupApi.findGroupList(sysGroupRequest, true);
        List records = result.getRecords();
        for (DatabaseInfo record : records) {
            record.setPassword("***");
            for (SysGroupDTO sysGroupDTO : list) {
                if (!record.getDbId().equals(sysGroupDTO.getBusinessId())) continue;
                record.setGroupName(sysGroupDTO.getGroupName());
            }
        }
        return PageResultFactory.createPageResult((Page)result);
    }

    @Override
    public List<DatabaseInfo> findList(DatabaseInfoRequest databaseInfoRequest) {
        LambdaQueryWrapper<DatabaseInfo> wrapper = this.createWrapper(databaseInfoRequest);
        List list = this.list((Wrapper)wrapper);
        for (DatabaseInfo record : list) {
            record.setPassword("***");
        }
        return list;
    }

    @Override
    public DatabaseInfo detail(DatabaseInfoRequest databaseInfoRequest) {
        DatabaseInfo databaseInfo = this.queryDatabaseInfoById(databaseInfoRequest);
        databaseInfo.setPassword("***");
        return databaseInfo;
    }

    @Override
    public void validateConnection(DatabaseInfoRequest param) {
        Connection conn = null;
        try {
            Class.forName(param.getJdbcDriver());
            conn = DriverManager.getConnection(param.getJdbcUrl(), param.getUsername(), param.getPassword());
        }
        catch (Exception e) {
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.VALIDATE_DATASOURCE_ERROR, new Object[]{param.getJdbcUrl(), e.getMessage()});
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DataSourceDto getDataSourceInfoById(Long dbId) {
        DataSourceDto dataSourceDto = new DataSourceDto();
        DatabaseInfoRequest databaseInfoRequest = new DatabaseInfoRequest();
        databaseInfoRequest.setDbId(dbId);
        DatabaseInfo databaseInfo = this.queryDatabaseInfoById(databaseInfoRequest);
        BeanUtil.copyProperties((Object)((Object)databaseInfo), (Object)dataSourceDto, (String[])new String[0]);
        return dataSourceDto;
    }

    private void addDataSourceToContext(DatabaseInfo databaseInfo, Boolean removeOldDatasource) {
        if (removeOldDatasource.booleanValue()) {
            DataSourceContext.removeDataSource((String)databaseInfo.getDbName());
        } else {
            DataSource dataSource = (DataSource)DataSourceContext.getDataSources().get(databaseInfo.getDbName());
            if (dataSource != null) {
                String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.DATASOURCE_NAME_REPEAT.getUserTip(), (Object[])new Object[]{databaseInfo.getDbName()});
                throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.DATASOURCE_NAME_REPEAT, new Object[]{userTip});
            }
        }
        DruidProperties druidProperties = DruidPropertiesFactory.createDruidProperties(databaseInfo);
        DruidDataSource druidDataSource = DruidDatasourceFactory.createDruidDataSource((DruidProperties)druidProperties);
        DataSourceContext.addDataSource((String)databaseInfo.getDbName(), (DataSource)druidDataSource, (DruidProperties)druidProperties);
        try {
            druidDataSource.init();
        }
        catch (SQLException exception) {
            this.log.error("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5f02\u5e38\uff01", (Throwable)exception);
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.INIT_DATASOURCE_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.INIT_DATASOURCE_ERROR, new Object[]{userTip});
        }
    }

    private DatabaseInfo queryDatabaseInfoById(DatabaseInfoRequest databaseInfoRequest) {
        DatabaseInfo databaseInfo = (DatabaseInfo)((Object)this.getById(databaseInfoRequest.getDbId()));
        if (databaseInfo == null) {
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.DATASOURCE_INFO_NOT_EXISTED, new Object[]{databaseInfoRequest.getDbId()});
        }
        return databaseInfo;
    }

    private LambdaQueryWrapper<DatabaseInfo> createWrapper(DatabaseInfoRequest databaseInfoRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DatabaseInfo::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)databaseInfoRequest)) {
            return queryWrapper;
        }
        String dbName = databaseInfoRequest.getDbName();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)dbName), DatabaseInfo::getDbName, (Object)dbName);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)databaseInfoRequest.getStatusFlag()), DatabaseInfo::getStatusFlag, (Object)databaseInfoRequest.getStatusFlag());
        String conditionGroupName = databaseInfoRequest.getConditionGroupName();
        if (ObjectUtil.isNotEmpty((Object)conditionGroupName) && !conditionGroupName.equals("\u6240\u6709\u5206\u7ec4")) {
            SysGroupRequest sysGroupRequest = new SysGroupRequest();
            sysGroupRequest.setGroupBizCode("DATASOURCE");
            if (conditionGroupName.equals("\u672a\u5206\u7ec4")) {
                List userBizIds = this.groupApi.findUserGroupDataList(sysGroupRequest);
                queryWrapper.nested(ObjectUtil.isNotEmpty((Object)userBizIds), i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.notIn(DatabaseInfo::getDbId, (Collection)userBizIds);
                });
            } else {
                sysGroupRequest.setGroupName(conditionGroupName);
                List userBizIds = this.groupApi.findUserGroupDataList(sysGroupRequest);
                queryWrapper.nested(ObjectUtil.isNotEmpty((Object)userBizIds), i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.in(DatabaseInfo::getDbId, (Collection)userBizIds);
                });
            }
        }
        return queryWrapper;
    }
}

