/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.api.pojo.DictDetail;
import cn.stylefeng.roses.kernel.dict.api.pojo.DictTreeDto;
import cn.stylefeng.roses.kernel.dict.api.pojo.SimpleDictUpdateParam;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.dict.modular.factory.DictFactory;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.dict.modular.service.DictTypeService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.tree.buildpids.PidStructureBuildUtil;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, SysDict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private PinYinApi pinYinApi;
    @Resource
    private DictTypeService dictTypeService;

    @Override
    public List<TreeDictInfo> getTreeDictList(DictRequest dictRequest) {
        List<SysDict> sysDictList = this.findList(dictRequest);
        if (ObjectUtil.isEmpty(sysDictList)) {
            return new ArrayList<TreeDictInfo>();
        }
        ArrayList<TreeDictInfo> treeDictInfos = new ArrayList<TreeDictInfo>();
        for (SysDict sysDict : sysDictList) {
            TreeDictInfo treeDictInfo = new TreeDictInfo();
            treeDictInfo.setDictId(sysDict.getDictId());
            treeDictInfo.setDictParentId(sysDict.getDictParentId());
            treeDictInfo.setDictCode(sysDict.getDictCode());
            treeDictInfo.setDictName(sysDict.getDictName());
            treeDictInfo.setDictSort(sysDict.getDictSort());
            treeDictInfos.add(treeDictInfo);
        }
        return new DefaultTreeBuildFactory().doTreeBuild(treeDictInfos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DictRequest dictRequest) {
        this.validateRepeat(dictRequest, false);
        SysDict sysDict = new SysDict();
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)sysDict), (String[])new String[0]);
        sysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDict.getDictName()));
        String pids = this.createPids(sysDict.getDictParentId());
        sysDict.setDictPids(pids);
        this.save((Object)sysDict);
    }

    @Override
    public void del(DictRequest dictRequest) {
        this.removeById(dictRequest.getDictId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(DictRequest dictRequest) {
        this.validateRepeat(dictRequest, true);
        SysDict sysDict = this.querySysDict(dictRequest);
        BeanUtil.copyProperties((Object)((Object)dictRequest), (Object)((Object)sysDict), (String[])new String[0]);
        sysDict.setDictTypeId(null);
        sysDict.setDictCode(null);
        sysDict.setDictParentId(null);
        sysDict.setDictNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDict.getDictName()));
        this.updateById((Object)sysDict);
    }

    @Override
    public SysDict detail(DictRequest dictRequest) {
        SysDict sysDict = this.querySysDict(dictRequest);
        if (ObjectUtil.isNotEmpty((Object)sysDict.getDictTypeId())) {
            SysDictType sysDictType = (SysDictType)((Object)this.dictTypeService.getById(sysDict.getDictTypeId()));
            sysDict.setDictTypeName(sysDictType.getDictTypeName());
        }
        return sysDict;
    }

    @Override
    public List<SysDict> findList(DictRequest dictRequest) {
        LambdaQueryWrapper<SysDict> wrapper = this.createWrapper(dictRequest);
        wrapper.select(new SFunction[]{SysDict::getDictName, SysDict::getDictCode, SysDict::getDictSort, SysDict::getDictId, SysDict::getDictParentId});
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void removeByDictTypeId(Long dictTypeId) {
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeId, (Object)dictTypeId);
        this.remove((Wrapper)sysDictLambdaQueryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDictTree(DictRequest dictRequest) {
        List<SysDict> totalDictStructure = dictRequest.getTotalDictStructure();
        DictFactory.updateSort(totalDictStructure, 1);
        DictFactory.fillParentId(-1L, totalDictStructure);
        ArrayList<SysDict> totalDictList = new ArrayList<SysDict>();
        DictFactory.collectTreeTasks(totalDictStructure, totalDictList);
        PidStructureBuildUtil.createPidStructure(totalDictList);
        this.updateBatchById(totalDictList);
    }

    public String getDictName(String dictTypeCode, String dictCode) {
        Long dictTypeId = this.dictTypeService.getDictTypeIdByDictTypeCode(dictTypeCode);
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeId, (Object)dictTypeId);
        sysDictLambdaQueryWrapper.eq(SysDict::getDictCode, (Object)dictCode);
        sysDictLambdaQueryWrapper.select(new SFunction[]{SysDict::getDictName});
        List list = this.list((Wrapper)sysDictLambdaQueryWrapper);
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() > 1) {
            log.error(DictExceptionEnum.DICT_CODE_REPEAT.getUserTip(), (Object)"", (Object)dictCode);
            return "";
        }
        return ((SysDict)((Object)list.get(0))).getDictName();
    }

    public List<SimpleDict> getDictDetailsByDictTypeCode(String dictTypeCode, String searchText) {
        Long dictTypeId = this.dictTypeService.getDictTypeIdByDictTypeCode(dictTypeCode);
        if (dictTypeId == null) {
            return new ArrayList<SimpleDict>();
        }
        DictRequest dictRequest = new DictRequest();
        dictRequest.setDictTypeId(dictTypeId);
        dictRequest.setSearchText(searchText);
        LambdaQueryWrapper<SysDict> wrapper = this.createWrapper(dictRequest);
        wrapper.select(new SFunction[]{SysDict::getDictId, SysDict::getDictName, SysDict::getDictCode});
        List dictList = this.list((Wrapper)wrapper);
        if (dictList.isEmpty()) {
            return new ArrayList<SimpleDict>();
        }
        ArrayList<SimpleDict> simpleDictList = new ArrayList<SimpleDict>();
        for (SysDict sysDict : dictList) {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setCode(sysDict.getDictCode());
            simpleDict.setName(sysDict.getDictName());
            simpleDict.setId(sysDict.getDictId());
            simpleDictList.add(simpleDict);
        }
        return simpleDictList;
    }

    public void deleteByDictId(Long dictId) {
        this.removeById(dictId);
    }

    public DictDetail getDictByDictId(Long dictId) {
        if (dictId == null) {
            return new DictDetail();
        }
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictId, (Object)dictId);
        sysDictLambdaQueryWrapper.select(new SFunction[]{SysDict::getDictName, SysDict::getDictCode, SysDict::getDictId, SysDict::getDictSort});
        SysDict sysDict = (SysDict)((Object)this.getOne((Wrapper)sysDictLambdaQueryWrapper, false));
        if (sysDict == null) {
            return new DictDetail();
        }
        return new DictDetail(sysDict.getDictId(), sysDict.getDictCode(), sysDict.getDictName(), sysDict.getDictSort());
    }

    public String getDictNameByDictId(Long dictId) {
        if (dictId == null) {
            return "";
        }
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictId, (Object)dictId);
        sysDictLambdaQueryWrapper.select(new SFunction[]{SysDict::getDictName});
        SysDict sysDict = (SysDict)((Object)this.getOne((Wrapper)sysDictLambdaQueryWrapper, false));
        if (sysDict == null) {
            return "";
        }
        return sysDict.getDictName();
    }

    public void simpleAddDict(SimpleDictUpdateParam simpleDictUpdateParam) {
        DictRequest dictRequest = new DictRequest();
        BeanUtil.copyProperties((Object)simpleDictUpdateParam, (Object)((Object)dictRequest), (String[])new String[0]);
        dictRequest.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.add(dictRequest);
    }

    public void simpleEditDict(SimpleDictUpdateParam simpleDictUpdateParam) {
        DictRequest dictRequest = new DictRequest();
        BeanUtil.copyProperties((Object)simpleDictUpdateParam, (Object)((Object)dictRequest), (String[])new String[0]);
        this.edit(dictRequest);
    }

    public List<DictTreeDto> buildDictTreeStructure() {
        LambdaQueryWrapper dictTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        dictTypeLambdaQueryWrapper.select(new SFunction[]{SysDictType::getDictTypeCode, SysDictType::getDictTypeName});
        dictTypeLambdaQueryWrapper.orderByAsc(SysDictType::getDictTypeSort);
        List dictTypeList = this.dictTypeService.list((Wrapper)dictTypeLambdaQueryWrapper);
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.select(new SFunction[]{SysDict::getDictCode, SysDict::getDictName, SysDict::getDictTypeId});
        sysDictLambdaQueryWrapper.orderByAsc(SysDict::getDictSort);
        List dictList = this.list((Wrapper)sysDictLambdaQueryWrapper);
        HashMap<Long, DictTreeDto> dictTypeMap = new HashMap<Long, DictTreeDto>();
        for (SysDictType sysDictType : dictTypeList) {
            DictTreeDto dictTreeDto = new DictTreeDto();
            dictTreeDto.setDictLabel(sysDictType.getDictTypeName());
            dictTreeDto.setDictValue(sysDictType.getDictTypeCode());
            dictTypeMap.put(sysDictType.getDictTypeId(), dictTreeDto);
        }
        for (SysDict sysDict : dictList) {
            DictTreeDto dictTreeDto;
            Long dictTypeId = sysDict.getDictTypeId();
            if (ObjectUtil.isNotEmpty((Object)dictTypeId) || (dictTreeDto = (DictTreeDto)dictTypeMap.get(dictTypeId)) == null) continue;
            ArrayList<DictTreeDto> children = dictTreeDto.getChildren();
            if (ObjectUtil.isEmpty((Object)children)) {
                children = new ArrayList<DictTreeDto>();
            }
            DictTreeDto dictValue = new DictTreeDto();
            dictValue.setDictLabel(sysDict.getDictName());
            dictValue.setDictValue(sysDict.getDictCode());
            children.add(dictValue);
            dictTreeDto.setChildren(children);
        }
        return ListUtil.list((boolean)true, dictTypeMap.values());
    }

    @Override
    public String getPinyin(String name) {
        if (ObjectUtil.isNotEmpty((Object)name)) {
            name = this.pinYinApi.parsePinyinString(name);
        }
        return name;
    }

    private SysDict querySysDict(DictRequest dictRequest) {
        SysDict sysDict = (SysDict)((Object)this.getById(dictRequest.getDictId()));
        if (ObjectUtil.isNull((Object)((Object)sysDict))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_NOT_EXISTED, new Object[]{dictRequest.getDictId()});
        }
        return sysDict;
    }

    private LambdaQueryWrapper<SysDict> createWrapper(DictRequest dictRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = dictRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(SysDict::getDictName, (Object)searchText)).or()).like(SysDict::getDictCode, (Object)searchText)).or()).like(SysDict::getDictNamePinyin, (Object)searchText));
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)dictRequest.getDictTypeId()), SysDict::getDictTypeId, (Object)dictRequest.getDictTypeId());
        if (StrUtil.isNotBlank((CharSequence)dictRequest.getDictTypeCode())) {
            Long dictTypeId = this.dictTypeService.getDictTypeIdByDictTypeCode(dictRequest.getDictTypeCode());
            if (dictTypeId != null) {
                queryWrapper.eq(SysDict::getDictTypeId, (Object)dictTypeId);
            } else {
                queryWrapper.eq(SysDict::getDictTypeId, (Object)-1L);
            }
        }
        queryWrapper.orderByAsc(SysDict::getDictSort);
        return queryWrapper;
    }

    private void validateRepeat(DictRequest dictRequest, boolean editFlag) {
        long dictNameCount;
        long count;
        LambdaQueryWrapper sysDictLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictLambdaQueryWrapper.eq(SysDict::getDictTypeId, (Object)dictRequest.getDictTypeId());
        sysDictLambdaQueryWrapper.eq(SysDict::getDictCode, (Object)dictRequest.getDictCode());
        if (editFlag) {
            sysDictLambdaQueryWrapper.ne(SysDict::getDictId, (Object)dictRequest.getDictId());
        }
        if ((count = this.count((Wrapper)sysDictLambdaQueryWrapper)) > 0L) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_CODE_REPEAT, new Object[]{dictRequest.getDictTypeId(), dictRequest.getDictCode()});
        }
        LambdaQueryWrapper dictNameWrapper = new LambdaQueryWrapper();
        dictNameWrapper.eq(SysDict::getDictTypeId, (Object)dictRequest.getDictTypeId());
        dictNameWrapper.eq(SysDict::getDictName, (Object)dictRequest.getDictName());
        if (editFlag) {
            dictNameWrapper.ne(SysDict::getDictId, (Object)dictRequest.getDictId());
        }
        if ((dictNameCount = this.count((Wrapper)dictNameWrapper)) > 0L) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_NAME_REPEAT, new Object[]{dictRequest.getDictTypeId(), dictRequest.getDictCode()});
        }
    }

    private String createPids(Long dictParentId) {
        if (dictParentId.equals(TreeConstants.DEFAULT_PARENT_ID)) {
            return "[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",";
        }
        LambdaQueryWrapper dictWrapper = new LambdaQueryWrapper();
        dictWrapper.eq(SysDict::getDictId, (Object)dictParentId);
        dictWrapper.select(new SFunction[]{SysDict::getDictPids});
        SysDict parentDictInfo = (SysDict)((Object)this.getOne((Wrapper)dictWrapper, false));
        if (parentDictInfo == null) {
            return "[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",";
        }
        return parentDictInfo.getDictPids() + "[" + dictParentId + "]" + ",";
    }

    @Override
    public void batchDelete(DictRequest dictRequest) {
        this.removeBatchByIds(dictRequest.getDictIdList());
    }
}

