/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.controller;

import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.rule.annotation.ApiLog;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u5b57\u5178\u8be6\u60c5\u7ba1\u7406")
public class DictController {
    @Resource
    private DictService dictService;

    @GetResource(name="\u83b7\u53d6\u6811\u5f62\u5b57\u5178\u5217\u8868", path={"/dict/getDictTreeList"})
    public ResponseData<List<TreeDictInfo>> getDictTreeList(@Validated(value={DictRequest.treeList.class}) DictRequest dictRequest) {
        List<TreeDictInfo> treeDictList = this.dictService.getTreeDictList(dictRequest);
        return new SuccessResponseData(treeDictList);
    }

    @PostResource(name="\u6dfb\u52a0\u5b57\u5178", path={"/dict/add"}, requiredPermission=true, requirePermissionCode="ADD_DICT")
    @ApiLog
    public ResponseData<?> add(@RequestBody @Validated(value={BaseRequest.add.class}) DictRequest dictRequest) {
        this.dictService.add(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u6279\u91cf\u5220\u9664\u5b57\u5178\u6761\u76ee", path={"/dict/batchDelete"}, requiredPermission=true, requirePermissionCode="DELETE_DICT")
    public ResponseData<?> batchDelete(@RequestBody @Validated(value={BaseRequest.batchDelete.class}) DictRequest dictRequest) {
        this.dictService.batchDelete(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664\u5b57\u5178", path={"/dict/delete"}, requiredPermission=true, requirePermissionCode="DELETE_DICT")
    @ApiLog
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) DictRequest dictRequest) {
        this.dictService.del(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u5b57\u5178", path={"/dict/edit"}, requiredPermission=true, requirePermissionCode="EDIT_DICT")
    @ApiLog
    public ResponseData<?> edit(@RequestBody @Validated(value={BaseRequest.edit.class}) DictRequest dictRequest) {
        this.dictService.edit(dictRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5", path={"/dict/detail"})
    public ResponseData<SysDict> detail(@Validated(value={BaseRequest.detail.class}) DictRequest dictRequest) {
        SysDict detail2 = this.dictService.detail(dictRequest);
        return new SuccessResponseData((Object)detail2);
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868", path={"/dict/list"})
    public ResponseData<List<SysDict>> list(DictRequest dictRequest) {
        return new SuccessResponseData(this.dictService.findList(dictRequest));
    }

    @PostResource(name="\u66f4\u65b0\u6574\u4e2a\u5b57\u5178\u6811\u7ed3\u6784\uff0c\u7528\u6765\u66f4\u65b0\u4e0a\u4e0b\u7ea7\u7ed3\u6784\u548c\u987a\u5e8f", path={"/dict/updateDictTree"}, requiredPermission=true, requirePermissionCode="EDIT_DICT")
    public ResponseData<List<SysDict>> updateDictTree(@RequestBody @Validated(value={DictRequest.updateTree.class}) DictRequest dictRequest) {
        this.dictService.updateDictTree(dictRequest);
        return new SuccessResponseData();
    }
}

