/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.dict.api.enums.DictTypeClassEnum;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictTypeMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictTypeRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.dict.modular.service.DictTypeService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTypeServiceImpl
extends ServiceImpl<DictTypeMapper, SysDictType>
implements DictTypeService {
    @Resource
    private PinYinApi pinYinApi;
    @Resource
    private DictService dictService;

    @Override
    public void add(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = new SysDictType();
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)sysDictType), (String[])new String[0]);
        sysDictType.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDictType.getDictTypeName()));
        this.save((Object)sysDictType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        this.removeById(dictTypeRequest.getDictTypeId());
        this.dictService.removeByDictTypeId(dictTypeRequest.getDictTypeId());
    }

    @Override
    public void edit(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = this.querySysDictType(dictTypeRequest);
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)sysDictType), (String[])new String[0]);
        sysDictType.setDictTypeCode(null);
        sysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDictType.getDictTypeName()));
        this.updateById((Object)sysDictType);
    }

    @Override
    public SysDictType detail(DictTypeRequest dictTypeRequest) {
        return this.querySysDictType(dictTypeRequest);
    }

    @Override
    public List<SysDictType> findList(DictTypeRequest dictTypeRequest) {
        LambdaQueryWrapper<SysDictType> wrapper = this.createWrapper(dictTypeRequest);
        wrapper.select(new SFunction[]{SysDictType::getDictTypeName, SysDictType::getDictTypeId});
        return this.list((Wrapper)wrapper);
    }

    public Long getDictTypeIdByDictTypeCode(String dictTypeCode) {
        if (ObjectUtil.isEmpty((Object)dictTypeCode)) {
            return null;
        }
        LambdaQueryWrapper sysDictTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        sysDictTypeLambdaQueryWrapper.eq(SysDictType::getDictTypeCode, (Object)dictTypeCode);
        sysDictTypeLambdaQueryWrapper.select(new SFunction[]{SysDictType::getDictTypeId});
        SysDictType sysDictType = (SysDictType)((Object)this.getOne((Wrapper)sysDictTypeLambdaQueryWrapper));
        if (sysDictType == null) {
            return null;
        }
        return sysDictType.getDictTypeId();
    }

    private void validateSystemTypeClassOperate(DictTypeRequest dictTypeRequest) {
        if (DictTypeClassEnum.SYSTEM_TYPE.getCode().equals(dictTypeRequest.getDictTypeClass()) && !LoginContext.me().getSuperAdminFlag()) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.SYSTEM_DICT_NOT_ALLOW_OPERATION);
        }
    }

    private SysDictType querySysDictType(DictTypeRequest dictTypeRequest) {
        SysDictType sysDictType = (SysDictType)((Object)this.getById(dictTypeRequest.getDictTypeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysDictType))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_TYPE_NOT_EXISTED, new Object[]{dictTypeRequest.getDictTypeId()});
        }
        return sysDictType;
    }

    private LambdaQueryWrapper<SysDictType> createWrapper(DictTypeRequest dictTypeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = dictTypeRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.like(SysDictType::getDictTypeName, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysDictType::getDictTypeCode, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysDictType::getDictTypeNamePinyin, (Object)searchText);
        }
        return queryWrapper;
    }
}

