/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.controller;

import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDict;
import cn.stylefeng.roses.kernel.dict.modular.pojo.TreeDictInfo;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictService;
import cn.stylefeng.roses.kernel.rule.annotation.BusinessLog;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u5b57\u5178\u8be6\u60c5\u7ba1\u7406")
public class DictController {
    @Resource
    private DictService dictService;

    @PostResource(name="\u6dfb\u52a0\u5b57\u5178", path={"/dict/add"})
    @BusinessLog
    public ResponseData<?> add(@RequestBody @Validated(value={BaseRequest.add.class}) DictRequest dictRequest) {
        this.dictService.add(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664\u5b57\u5178", path={"/dict/delete"})
    @BusinessLog
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) DictRequest dictRequest) {
        this.dictService.del(dictRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u5b57\u5178", path={"/dict/edit"})
    @BusinessLog
    public ResponseData<?> edit(@RequestBody @Validated(value={BaseRequest.edit.class}) DictRequest dictRequest) {
        this.dictService.edit(dictRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5", path={"/dict/detail"}, requiredPermission=false)
    public ResponseData<SysDict> detail(@Validated(value={BaseRequest.detail.class}) DictRequest dictRequest) {
        SysDict detail2 = this.dictService.detail(dictRequest);
        return new SuccessResponseData((Object)detail2);
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868", path={"/dict/list"}, requiredPermission=false)
    public ResponseData<List<SysDict>> list(DictRequest dictRequest) {
        return new SuccessResponseData(this.dictService.findList(dictRequest));
    }

    @GetResource(name="\u83b7\u53d6\u5b57\u5178\u5217\u8868", path={"/dict/page"}, requiredPermission=false)
    public ResponseData<PageResult<SysDict>> page(DictRequest dictRequest) {
        return new SuccessResponseData(this.dictService.findPage(dictRequest));
    }

    @GetResource(name="\u83b7\u53d6\u6811\u5f62\u5b57\u5178\u5217\u8868", path={"/dict/getDictTreeList"}, requiredPermission=false)
    public ResponseData<List<TreeDictInfo>> getDictTreeList(@Validated(value={DictRequest.treeList.class}) DictRequest dictRequest) {
        List<TreeDictInfo> treeDictList = this.dictService.getTreeDictList(dictRequest);
        return new SuccessResponseData(treeDictList);
    }

    @GetResource(name="\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u5206\u7ec4\u5b57\u5178\u5217\u8868", path={"/dict/getConfigGroupPage"}, requiredPermission=false)
    public ResponseData<PageResult<SysDict>> getConfigGroupPage(DictRequest dictRequest) {
        dictRequest.setDictTypeCode("config_group");
        PageResult<SysDict> page = this.dictService.findPage(dictRequest);
        return new SuccessResponseData(page);
    }

    @GetResource(name="\u83b7\u53d6\u591a\u8bed\u8a00\u5b57\u5178\u5217\u8868", path={"/dict/getLanguagesPage"}, requiredPermission=false)
    public ResponseData<PageResult<SysDict>> getLanguagesPage(DictRequest dictRequest) {
        dictRequest.setDictTypeCode("languages");
        PageResult<SysDict> page = this.dictService.findPage(dictRequest);
        return new SuccessResponseData(page);
    }
}

