/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.enums.DictTypeClassEnum;
import cn.stylefeng.roses.kernel.dict.api.exception.DictException;
import cn.stylefeng.roses.kernel.dict.api.exception.enums.DictExceptionEnum;
import cn.stylefeng.roses.kernel.dict.modular.entity.SysDictType;
import cn.stylefeng.roses.kernel.dict.modular.mapper.DictTypeMapper;
import cn.stylefeng.roses.kernel.dict.modular.pojo.request.DictTypeRequest;
import cn.stylefeng.roses.kernel.dict.modular.service.DictTypeService;
import cn.stylefeng.roses.kernel.pinyin.api.PinYinApi;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTypeServiceImpl
extends ServiceImpl<DictTypeMapper, SysDictType>
implements DictTypeService {
    @Resource
    private PinYinApi pinYinApi;

    @Override
    public void add(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = new SysDictType();
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)sysDictType), (String[])new String[0]);
        sysDictType.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDictType.getDictTypeName()));
        this.save((Object)sysDictType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = this.querySysDictType(dictTypeRequest);
        sysDictType.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysDictType);
    }

    @Override
    public void edit(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType sysDictType = this.querySysDictType(dictTypeRequest);
        BeanUtil.copyProperties((Object)((Object)dictTypeRequest), (Object)((Object)sysDictType), (String[])new String[0]);
        sysDictType.setDictTypeCode(null);
        sysDictType.setDictTypeNamePinyin(this.pinYinApi.parseEveryPinyinFirstLetter(sysDictType.getDictTypeName()));
        this.updateById((Object)sysDictType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editStatus(DictTypeRequest dictTypeRequest) {
        this.validateSystemTypeClassOperate(dictTypeRequest);
        SysDictType oldSysDictType = this.querySysDictType(dictTypeRequest);
        oldSysDictType.setStatusFlag(dictTypeRequest.getStatusFlag());
        this.updateById((Object)oldSysDictType);
    }

    @Override
    public SysDictType detail(DictTypeRequest dictTypeRequest) {
        return (SysDictType)((Object)this.getOne((Wrapper)this.createWrapper(dictTypeRequest), false));
    }

    @Override
    public List<SysDictType> findList(DictTypeRequest dictTypeRequest) {
        return this.list((Wrapper)this.createWrapper(dictTypeRequest));
    }

    @Override
    public PageResult<SysDictType> findPage(DictTypeRequest dictTypeRequest) {
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)this.createWrapper(dictTypeRequest));
        return PageResultFactory.createPageResult((Page)page);
    }

    private void validateSystemTypeClassOperate(DictTypeRequest dictTypeRequest) {
        if (DictTypeClassEnum.SYSTEM_TYPE.getCode().equals(dictTypeRequest.getDictTypeClass()) && !LoginContext.me().getSuperAdminFlag()) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.SYSTEM_DICT_NOT_ALLOW_OPERATION);
        }
    }

    private SysDictType querySysDictType(DictTypeRequest dictTypeRequest) {
        SysDictType sysDictType = (SysDictType)((Object)this.getById(dictTypeRequest.getDictTypeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysDictType))) {
            throw new DictException((AbstractExceptionEnum)DictExceptionEnum.DICT_TYPE_NOT_EXISTED, new Object[]{dictTypeRequest.getDictTypeId()});
        }
        return sysDictType;
    }

    private LambdaQueryWrapper<SysDictType> createWrapper(DictTypeRequest dictTypeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long dictTypeId = dictTypeRequest.getDictTypeId();
        String dictTypeCode = dictTypeRequest.getDictTypeCode();
        String dictTypeName = dictTypeRequest.getDictTypeName();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)dictTypeId), SysDictType::getDictTypeId, (Object)dictTypeId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)dictTypeCode), SysDictType::getDictTypeCode, (Object)dictTypeCode);
        queryWrapper.like(ObjectUtil.isNotNull((Object)dictTypeName), SysDictType::getDictTypeName, (Object)dictTypeName);
        queryWrapper.eq(SysDictType::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        return queryWrapper;
    }
}

