/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dict.api.serializer;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.dict.api.context.DictContext;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class DictValueSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "|";
    private static final String NULL_STR = "null";
    private static final String VALUE_SEPARATOR = ",";

    public DictValueSerializer() {
        super(String.class, false);
    }

    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.length() == 0;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        String fieldValue = value.toString();
        if (StrUtil.isBlank((CharSequence)fieldValue) || !fieldValue.contains(SEPARATOR)) {
            fieldValue = "";
            gen.writeString(fieldValue);
            return;
        }
        String[] dictTypeCodeAndDictCode = fieldValue.split("\\|");
        if (dictTypeCodeAndDictCode.length != 2) {
            fieldValue = "";
            gen.writeString(fieldValue);
            return;
        }
        String dictTypeCode = dictTypeCodeAndDictCode[0];
        String dictCode = dictTypeCodeAndDictCode[1];
        if (StrUtil.isBlank((CharSequence)dictCode) || NULL_STR.equals(dictCode)) {
            fieldValue = "";
            gen.writeString(fieldValue);
            return;
        }
        if (dictCode.contains(VALUE_SEPARATOR)) {
            String[] dictCodeArray = dictCode.split(VALUE_SEPARATOR);
            StringBuilder dictNames = new StringBuilder();
            for (String singleDictCode : dictCodeArray) {
                String dictName = DictContext.me().getDictName(dictTypeCode, singleDictCode);
                if (!StrUtil.isNotBlank((CharSequence)dictName)) continue;
                dictNames.append(dictName).append(VALUE_SEPARATOR);
            }
            fieldValue = StrUtil.removeSuffix((CharSequence)dictNames.toString(), (CharSequence)VALUE_SEPARATOR);
            gen.writeString(fieldValue);
            return;
        }
        fieldValue = DictContext.me().getDictName(dictTypeCode, dictCode);
        gen.writeString(fieldValue);
    }

    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

