/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.demo.interceptor;

import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.demo.exception.DemoException;
import cn.stylefeng.roses.kernel.demo.exception.enums.DemoExceptionEnum;
import cn.stylefeng.roses.kernel.demo.expander.DemoConfigExpander;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Connection;
import java.util.Iterator;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.util.AntPathMatcher;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DemoProfileSqlInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        Iterator iterator = AuthConfigExpander.getNoneSecurityConfig().iterator();
        while (iterator.hasNext()) {
            AntPathMatcher antPathMatcher = new AntPathMatcher();
            String notAuthResource = (String)iterator.next();
            if (!antPathMatcher.match(notAuthResource, HttpServletUtil.getRequest().getRequestURI())) continue;
            return invocation.proceed();
        }
        throw new DemoException((AbstractExceptionEnum)DemoExceptionEnum.DEMO_OPERATE);
    }
}

