/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.starter;

import cn.stylefeng.roses.kernel.db.api.pojo.tenant.TenantTableProperties;
import cn.stylefeng.roses.kernel.db.mp.datascope.ProjectDataScopeHandler;
import cn.stylefeng.roses.kernel.db.mp.dbid.CustomDatabaseIdProvider;
import cn.stylefeng.roses.kernel.db.mp.fieldfill.CustomMetaObjectHandler;
import cn.stylefeng.roses.kernel.db.mp.injector.CustomInsertBatchSqlInjector;
import cn.stylefeng.roses.kernel.db.mp.tenant.ProjectTenantInterceptor;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={MybatisPlusAutoConfiguration.class})
public class ProjectMyBatisPlusAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="tenant")
    @ConditionalOnMissingBean(value={TenantTableProperties.class})
    public TenantTableProperties tenantTableProperties() {
        return new TenantTableProperties();
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(TenantTableProperties tenantTableProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)this.tenantLineInnerInterceptor(tenantTableProperties));
        interceptor.addInnerInterceptor((InnerInterceptor)this.dataPermissionInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.paginationInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.optimisticLockerInnerInterceptor());
        return interceptor;
    }

    @Bean
    public PaginationInnerInterceptor paginationInterceptor() {
        return new PaginationInnerInterceptor();
    }

    @Bean
    public OptimisticLockerInnerInterceptor optimisticLockerInnerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={MetaObjectHandler.class})
    public MetaObjectHandler metaObjectHandler() {
        return new CustomMetaObjectHandler();
    }

    @Bean
    public CustomDatabaseIdProvider customDatabaseIdProvider() {
        return new CustomDatabaseIdProvider();
    }

    @Bean
    public CustomInsertBatchSqlInjector customInsertBatchSqlInjector() {
        return new CustomInsertBatchSqlInjector();
    }

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantTableProperties tenantTableProperties) {
        return new TenantLineInnerInterceptor((TenantLineHandler)new ProjectTenantInterceptor(tenantTableProperties));
    }

    @Bean
    public DataPermissionInterceptor dataPermissionInterceptor() {
        return new DataPermissionInterceptor((DataPermissionHandler)new ProjectDataScopeHandler());
    }
}

