/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.flyway;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.exception.DaoException;
import cn.stylefeng.roses.kernel.db.api.exception.enums.FlywayExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.listener.ContextInitializedListener;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class FlywayInitListener
extends ContextInitializedListener
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(FlywayInitListener.class);
    private static final String FLYWAY_LOCATIONS = "classpath:db/migration/mysql";

    public void eventCallback(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String driverClassName = environment.getProperty("spring.datasource.driver-class-name");
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        Boolean enableSharding = (Boolean)environment.getProperty("spring.shardingsphere.enabled", Boolean.class);
        if (ObjectUtil.isNotNull((Object)enableSharding) && enableSharding.booleanValue()) {
            driverClassName = environment.getProperty("spring.shardingsphere.datasource.master.driver-class-name");
            dataSourceUrl = environment.getProperty("spring.shardingsphere.datasource.master.url");
            dataSourceUsername = environment.getProperty("spring.shardingsphere.datasource.master.username");
            dataSourcePassword = environment.getProperty("spring.shardingsphere.datasource.master.password");
        }
        String enabledStr = environment.getProperty("spring.flyway.enabled");
        String locations = environment.getProperty("spring.flyway.locations");
        String baselineOnMigrateStr = environment.getProperty("spring.flyway.baseline-on-migrate");
        String outOfOrderStr = environment.getProperty("spring.flyway.out-of-order");
        String placeholder = environment.getProperty("spring.flyway.placeholder-replacement");
        boolean enabled = false;
        if (StrUtil.isNotBlank((CharSequence)enabledStr)) {
            enabled = Boolean.parseBoolean(enabledStr);
        }
        if (!enabled) {
            return;
        }
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword, driverClassName})) {
            throw new DaoException((AbstractExceptionEnum)FlywayExceptionEnum.DB_CONFIG_ERROR);
        }
        boolean baselineOnMigrate = false;
        if (StrUtil.isNotBlank((CharSequence)baselineOnMigrateStr)) {
            baselineOnMigrate = Boolean.parseBoolean(baselineOnMigrateStr);
        }
        if (StrUtil.isBlank((CharSequence)locations)) {
            locations = FLYWAY_LOCATIONS;
        }
        boolean outOfOrder = false;
        if (StrUtil.isNotBlank((CharSequence)outOfOrderStr)) {
            outOfOrder = Boolean.parseBoolean(outOfOrderStr);
        }
        boolean enablePlaceholder = true;
        if (StrUtil.isNotBlank((CharSequence)placeholder)) {
            enablePlaceholder = Boolean.parseBoolean(placeholder);
        }
        DriverManagerDataSource dmDataSource = null;
        try {
            assert (dataSourceUrl != null);
            dmDataSource = new DriverManagerDataSource();
            dmDataSource.setDriverClassName(driverClassName);
            dmDataSource.setUrl(dataSourceUrl);
            dmDataSource.setUsername(dataSourceUsername);
            dmDataSource.setPassword(dataSourcePassword);
            Flyway flyway = Flyway.configure().dataSource((DataSource)dmDataSource).locations(new String[]{locations}).baselineOnMigrate(baselineOnMigrate).outOfOrder(outOfOrder).placeholderReplacement(enablePlaceholder).load();
            flyway.migrate();
        }
        catch (Exception e) {
            log.error("flyway\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new DaoException((AbstractExceptionEnum)FlywayExceptionEnum.FLYWAY_MIGRATE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

