/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.customer.modular.factory;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleUserInfo;
import cn.stylefeng.roses.kernel.customer.api.expander.CustomerConfigExpander;
import cn.stylefeng.roses.kernel.customer.modular.entity.Customer;
import cn.stylefeng.roses.kernel.customer.modular.request.CustomerRequest;
import cn.stylefeng.roses.kernel.email.api.pojo.SendMailParam;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.constants.FileConstants;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import java.util.Collections;
import java.util.Date;

public class CustomerFactory {
    public static Customer createRegCustomer(CustomerRequest customerRequest) {
        Customer customer = new Customer();
        customer.setAccount(customerRequest.getAccount());
        PasswordStoredEncryptApi passwordStoredEncryptApi = (PasswordStoredEncryptApi)SpringUtil.getBean(PasswordStoredEncryptApi.class);
        customer.setPassword(passwordStoredEncryptApi.encrypt(customerRequest.getPassword()));
        customer.setNickName(customerRequest.getNickName());
        customer.setEmail(customerRequest.getEmail());
        customer.setVerifyCode(RandomUtil.randomString((int)29).toUpperCase());
        customer.setVerifiedFlag(YesOrNotEnum.N.getCode());
        customer.setAvatar(FileConstants.DEFAULT_AVATAR_FILE_ID);
        customer.setAvatarObjectName("defaultAvatar.png");
        customer.setScore(0);
        customer.setStatusFlag(StatusEnum.ENABLE.getCode());
        return customer;
    }

    public static SendMailParam createRegEmailParam(String mail, String verifyCode) {
        String title = CustomerConfigExpander.getRegMailTitle();
        String template = CustomerConfigExpander.getRegMailContent();
        SendMailParam sendMailParam = new SendMailParam();
        sendMailParam.setTos(Collections.singletonList(mail));
        sendMailParam.setTitle(title);
        sendMailParam.setContent(StrUtil.format((CharSequence)template, (Object[])new Object[]{verifyCode, verifyCode}));
        return sendMailParam;
    }

    public static LoginUser createLoginUser(Customer customer, FileOperatorApi fileOperatorApi) {
        LoginUser loginUser = new LoginUser();
        loginUser.setUserId(customer.getCustomerId());
        loginUser.setAccount(customer.getAccount());
        loginUser.setLoginTime(new Date());
        SimpleUserInfo simpleUserInfo = new SimpleUserInfo();
        simpleUserInfo.setAvatar(customer.getAvatar());
        simpleUserInfo.setNickName(customer.getNickName());
        simpleUserInfo.setEmail(customer.getEmail());
        simpleUserInfo.setPhone(customer.getTelephone());
        loginUser.setSimpleUserInfo(simpleUserInfo);
        String fileAuthUrl = fileOperatorApi.getFileUnAuthUrl(CustomerConfigExpander.getCustomerBucket(), customer.getAvatarObjectName());
        loginUser.setAvatarUrl(fileAuthUrl);
        loginUser.setCustomerFlag(Boolean.valueOf(true));
        return loginUser;
    }

    public static SendMailParam createResetPwdEmail(String mail, String randomCode) {
        String title = CustomerConfigExpander.getResetPwdMailTitle();
        String template = CustomerConfigExpander.getResetPwdMailContent();
        SendMailParam sendMailParam = new SendMailParam();
        sendMailParam.setTos(Collections.singletonList(mail));
        sendMailParam.setTitle(title);
        sendMailParam.setContent(StrUtil.format((CharSequence)template, (Object[])new Object[]{randomCode}));
        return sendMailParam;
    }
}

