/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.customer.modular.controller;

import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfo;
import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfoRequest;
import cn.stylefeng.roses.kernel.customer.modular.request.CustomerRequest;
import cn.stylefeng.roses.kernel.customer.modular.service.CustomerService;
import cn.stylefeng.roses.kernel.rule.annotation.BusinessLog;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="C\u7aef\u7528\u6237\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539")
public class CustomerInfoController {
    @Resource
    private CustomerService customerService;

    @GetResource(name="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f", path={"/customerInfo/getPersonInfo"}, requiredPermission=false)
    public ResponseData<CustomerInfo> getPersonInfo(@Validated(value={BaseRequest.detail.class}) CustomerRequest customerRequest) {
        CustomerInfo customerInfo = this.customerService.getCustomerInfoById(customerRequest.getCustomerId());
        return new SuccessResponseData((Object)customerInfo);
    }

    @PostResource(name="\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801", path={"/customerInfo/updatePassword"}, requiredPermission=false)
    @BusinessLog
    public ResponseData<?> updatePassword(@RequestBody @Validated(value={CustomerInfoRequest.changePassword.class}) CustomerInfoRequest customerInfoRequest) {
        this.customerService.updatePassword(customerInfoRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u4e2a\u4eba\u5934\u50cf", path={"/customerInfo/updateAvatar"}, requiredPermission=false)
    @BusinessLog
    public ResponseData<?> updateAvatar(@RequestBody @Validated(value={CustomerInfoRequest.changeAvatar.class}) CustomerInfoRequest customerInfoRequest) {
        this.customerService.updateAvatar(customerInfoRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u91cd\u7f6e\u4e2a\u4eba\u79d8\u94a5", path={"/customerInfo/resetPersonalSecret"}, requiredPermission=false)
    @BusinessLog
    public ResponseData<String> resetPersonalSecret() {
        String secret = this.customerService.updateSecret();
        return new SuccessResponseData((Object)secret);
    }
}

