/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.customer.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.customer.api.OldPasswordValidateApi;
import cn.stylefeng.roses.kernel.customer.api.exception.CustomerException;
import cn.stylefeng.roses.kernel.customer.api.exception.enums.CustomerExceptionEnum;
import cn.stylefeng.roses.kernel.customer.api.expander.CustomerConfigExpander;
import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfo;
import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfoRequest;
import cn.stylefeng.roses.kernel.customer.modular.entity.Customer;
import cn.stylefeng.roses.kernel.customer.modular.factory.CustomerFactory;
import cn.stylefeng.roses.kernel.customer.modular.mapper.CustomerMapper;
import cn.stylefeng.roses.kernel.customer.modular.request.CustomerRequest;
import cn.stylefeng.roses.kernel.customer.modular.service.CustomerService;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.email.api.MailSenderApi;
import cn.stylefeng.roses.kernel.email.api.pojo.SendMailParam;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.jwt.api.context.JwtContext;
import cn.stylefeng.roses.kernel.jwt.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.exception.enums.defaults.DefaultBusinessExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.security.api.DragCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.expander.SecurityConfigExpander;
import cn.stylefeng.roses.kernel.validator.api.exception.enums.ValidatorExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerServiceImpl
extends ServiceImpl<CustomerMapper, Customer>
implements CustomerService {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceImpl.class);
    private static final Object SESSION_OPERATE_LOCK = new Object();
    private static final Object REG_LOCK = new Object();
    @Resource
    private MailSenderApi mailSenderApi;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private LoginLogServiceApi loginLogServiceApi;
    @Resource
    private CacheOperatorApi<CustomerInfo> customerInfoCacheOperatorApi;
    @Resource
    private FileOperatorApi fileOperatorApi;
    @Resource
    private FileInfoApi fileInfoApi;
    @Resource
    private DragCaptchaApi dragCaptchaApi;
    @Resource
    private OldPasswordValidateApi oldPasswordValidateApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reg(CustomerRequest customerRequest) {
        this.validateDragCaptcha(customerRequest.getVerKey(), customerRequest.getVerCode());
        Object object = REG_LOCK;
        synchronized (object) {
            this.validateRepeat(customerRequest);
            Customer regCustomer = CustomerFactory.createRegCustomer(customerRequest);
            this.save((Object)regCustomer);
            try {
                SendMailParam regEmailParam = CustomerFactory.createRegEmailParam(regCustomer.getEmail(), regCustomer.getVerifyCode());
                this.mailSenderApi.sendMailHtml(regEmailParam);
            }
            catch (Exception exception) {
                log.error("\u6ce8\u518c\u65f6\uff0c\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01", (Throwable)exception);
                throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.EMAIL_SEND_ERROR);
            }
        }
    }

    @Override
    public void active(CustomerRequest customerRequest) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Customer::getVerifiedFlag, (Object)YesOrNotEnum.Y.getCode());
        wrapper.eq(Customer::getVerifyCode, (Object)customerRequest.getVerifyCode());
        boolean result = this.update((Wrapper)wrapper);
        if (!result) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.ACTIVE_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginResponse login(LoginRequest loginRequest) {
        Boolean passwordFlag;
        loginRequest.setCreateCookie(Boolean.valueOf(false));
        loginRequest.setRememberMe(Boolean.valueOf(true));
        this.validateDragCaptcha(loginRequest.getVerKey(), loginRequest.getVerCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Customer::getAccount, (Object)loginRequest.getAccount())).or()).eq(Customer::getEmail, (Object)loginRequest.getAccount())).or()).eq(Customer::getTelephone, (Object)loginRequest.getAccount());
        Customer customer = (Customer)((Object)this.getOne((Wrapper)wrapper, false));
        if (customer == null) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.CANT_FIND_CUSTOMER, new Object[]{loginRequest.getAccount()});
        }
        if (CustomerConfigExpander.getOldPasswordValidate() != false && customer.getPassword().equals("-1") ? !this.oldPasswordValidateApi.validatePassword(loginRequest.getPassword(), customer.getOldPassword(), customer.getOldPasswordSalt()) : (passwordFlag = this.passwordStoredEncryptApi.checkPassword(loginRequest.getPassword(), customer.getPassword())) == false) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USERNAME_PASSWORD_ERROR);
        }
        if (!StatusEnum.ENABLE.getCode().equals(customer.getStatusFlag())) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.CUSTOMER_STATUS_ERROR, new Object[]{customer.getStatusFlag()});
        }
        if (!YesOrNotEnum.Y.getCode().equals(customer.getVerifiedFlag())) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.CUSTOMER_NOT_VERIFIED);
        }
        LoginUser loginUser = CustomerFactory.createLoginUser(customer, this.fileOperatorApi);
        DefaultJwtPayload defaultJwtPayload = new DefaultJwtPayload(loginUser.getUserId(), loginUser.getAccount(), loginRequest.getRememberMe().booleanValue(), null);
        String jwtToken = JwtContext.me().generateTokenDefaultPayload(defaultJwtPayload);
        loginUser.setToken(jwtToken);
        Object object = SESSION_OPERATE_LOCK;
        synchronized (object) {
            this.sessionManagerApi.createSession(jwtToken, loginUser, loginRequest.getCreateCookie());
            if (AuthConfigExpander.getSingleAccountLoginFlag()) {
                this.sessionManagerApi.removeSessionExcludeToken(jwtToken);
            }
        }
        String ip = HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Customer::getCustomerId, (Object)loginUser.getUserId());
        updateWrapper.set(Customer::getLastLoginIp, (Object)ip);
        updateWrapper.set(Customer::getLastLoginTime, (Object)new Date());
        this.update((Wrapper)updateWrapper);
        this.loginLogServiceApi.loginSuccess(loginUser.getUserId());
        return new LoginResponse(loginUser, jwtToken, defaultJwtPayload.getExpirationDate());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sendResetPwdEmail(CustomerRequest customerRequest) {
        this.validateDragCaptcha(customerRequest.getVerKey(), customerRequest.getVerCode());
        LambdaQueryWrapper customerLambdaQueryWrapper = new LambdaQueryWrapper();
        customerLambdaQueryWrapper.eq(Customer::getEmail, (Object)customerRequest.getEmail());
        Customer customer = (Customer)((Object)this.getOne((Wrapper)customerLambdaQueryWrapper, false));
        if (customer == null) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.CANT_FIND_CUSTOMER, new Object[]{customerRequest.getEmail()});
        }
        String randomCode = RandomUtil.randomNumbers((int)6);
        customer.setVerifyCode(randomCode);
        this.updateById((Object)customer);
        SendMailParam resetPwdEmail = CustomerFactory.createResetPwdEmail(customerRequest.getEmail(), randomCode);
        this.mailSenderApi.sendMailHtml(resetPwdEmail);
    }

    @Override
    public void resetPassword(CustomerRequest customerRequest) {
        LambdaQueryWrapper customerLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)customerLambdaQueryWrapper.eq(Customer::getEmail, (Object)customerRequest.getEmail())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(Customer::getVerifyCode, (Object)customerRequest.getVerifyCode());
        });
        Customer customer = (Customer)((Object)this.getOne((Wrapper)customerLambdaQueryWrapper, false));
        if (customer == null) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.EMAIL_VERIFY_COD_ERROR);
        }
        String password = customerRequest.getPassword();
        String encrypt = this.passwordStoredEncryptApi.encrypt(password);
        customer.setPassword(encrypt);
        this.updateById((Object)customer);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customer.getCustomerId())});
    }

    @Override
    public void add(CustomerRequest customerRequest) {
        Customer customer = new Customer();
        BeanUtil.copyProperties((Object)((Object)customerRequest), (Object)((Object)customer), (String[])new String[0]);
        this.save((Object)customer);
    }

    @Override
    public void del(CustomerRequest customerRequest) {
        Customer customer = this.queryCustomer(customerRequest);
        this.removeById(customer.getCustomerId());
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customer.getCustomerId())});
    }

    @Override
    public void edit(CustomerRequest customerRequest) {
        Customer customer = this.queryCustomer(customerRequest);
        BeanUtil.copyProperties((Object)((Object)customerRequest), (Object)((Object)customer), (String[])new String[0]);
        this.updateById((Object)customer);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customer.getCustomerId())});
    }

    @Override
    public Customer detail(CustomerRequest customerRequest) {
        return this.queryCustomer(customerRequest);
    }

    @Override
    public PageResult<Customer> findPage(CustomerRequest customerRequest) {
        LambdaQueryWrapper<Customer> wrapper = this.createWrapper(customerRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<Customer> findList(CustomerRequest customerRequest) {
        LambdaQueryWrapper<Customer> wrapper = this.createWrapper(customerRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void updatePassword(CustomerInfoRequest customerInfoRequest) {
        CustomerRequest customerRequest = new CustomerRequest();
        customerRequest.setCustomerId(customerInfoRequest.getCustomerId());
        Customer customer = this.detail(customerRequest);
        Boolean passwordRightFlag = this.passwordStoredEncryptApi.checkPassword(customerInfoRequest.getOldPassword(), customer.getPassword());
        if (!passwordRightFlag.booleanValue()) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.PWD_ERROR);
        }
        String encryptPwd = this.passwordStoredEncryptApi.encrypt(customerInfoRequest.getNewPassword());
        customer.setPassword(encryptPwd);
        this.updateById((Object)customer);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customer.getCustomerId())});
    }

    @Override
    public void updateAvatar(CustomerInfoRequest customerInfoRequest) {
        CustomerRequest customerRequest = new CustomerRequest();
        customerRequest.setCustomerId(customerInfoRequest.getCustomerId());
        Customer customer = this.detail(customerRequest);
        SysFileInfoResponse fileInfo = this.fileInfoApi.getFileInfoWithoutContent(customerInfoRequest.getAvatar());
        customer.setAvatar(customerInfoRequest.getAvatar());
        customer.setAvatarObjectName(fileInfo.getFileObjectName());
        this.updateById((Object)customer);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customer.getCustomerId())});
    }

    @Override
    public String updateSecret() {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        String uuid = IdWorker.get32UUID();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Customer::getSecretKey, (Object)uuid);
        wrapper.eq(Customer::getCustomerId, (Object)userId);
        this.update((Wrapper)wrapper);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(userId)});
        return uuid;
    }

    public CustomerInfo getCustomerInfoById(Long customerId) {
        String customerIdKey = String.valueOf(customerId);
        CustomerInfo customerInfo = (CustomerInfo)this.customerInfoCacheOperatorApi.get(customerIdKey);
        if (customerInfo != null) {
            return customerInfo;
        }
        Customer customer = (Customer)((Object)this.getById(customerId));
        if (customer == null) {
            return null;
        }
        CustomerInfo result = new CustomerInfo();
        BeanUtil.copyProperties((Object)((Object)customer), (Object)result, (String[])new String[0]);
        String fileAuthUrl = this.fileOperatorApi.getFileUnAuthUrl(CustomerConfigExpander.getCustomerBucket(), customer.getAvatarObjectName());
        result.setAvatarObjectUrl(fileAuthUrl);
        if (result.getMemberExpireTime() == null) {
            result.setMemberFlag(Boolean.valueOf(false));
        } else if (DateUtil.compare((Date)result.getMemberExpireTime(), (Date)new Date()) < 0) {
            result.setMemberFlag(Boolean.valueOf(false));
        } else {
            result.setMemberFlag(Boolean.valueOf(true));
        }
        this.customerInfoCacheOperatorApi.put(customerIdKey, (Object)result, CustomerConfigExpander.getCustomerCacheExpiredSeconds());
        return result;
    }

    public CustomerInfo getCustomerInfoBySecretKey(String secretKey) {
        if (StrUtil.isEmpty((CharSequence)secretKey)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Customer::getSecretKey, (Object)secretKey);
        wrapper.select(new SFunction[]{Customer::getCustomerId});
        Customer customer = (Customer)((Object)this.getOne((Wrapper)wrapper, false));
        if (customer == null) {
            return null;
        }
        return this.getCustomerInfoById(customer.getCustomerId());
    }

    public void updateMemberExpiryDate(Long customerId, Date expiryDate) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Customer::getMemberExpireTime, (Object)expiryDate);
        wrapper.eq(Customer::getCustomerId, (Object)customerId);
        this.update((Wrapper)wrapper);
        this.customerInfoCacheOperatorApi.remove(new String[]{String.valueOf(customerId)});
    }

    private Customer queryCustomer(CustomerRequest customerRequest) {
        Customer customer = (Customer)((Object)this.getById(customerRequest.getCustomerId()));
        if (ObjectUtil.isEmpty((Object)((Object)customer))) {
            throw new ServiceException((AbstractExceptionEnum)DefaultBusinessExceptionEnum.SYSTEM_RUNTIME_ERROR);
        }
        return customer;
    }

    private LambdaQueryWrapper<Customer> createWrapper(CustomerRequest customerRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long customerId = customerRequest.getCustomerId();
        String account = customerRequest.getAccount();
        String password = customerRequest.getPassword();
        String nickName = customerRequest.getNickName();
        String email = customerRequest.getEmail();
        String telephone = customerRequest.getTelephone();
        Long avatar = customerRequest.getAvatar();
        String avatarObjectName = customerRequest.getAvatarObjectName();
        Integer score = customerRequest.getScore();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)customerId), Customer::getCustomerId, (Object)customerId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)account), Customer::getAccount, (Object)account);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)password), Customer::getPassword, (Object)password);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)nickName), Customer::getNickName, (Object)nickName);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)email), Customer::getEmail, (Object)email);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)telephone), Customer::getTelephone, (Object)telephone);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)avatar), Customer::getAvatar, (Object)avatar);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)avatarObjectName), Customer::getAvatarObjectName, (Object)avatarObjectName);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)score), Customer::getScore, (Object)score);
        return queryWrapper;
    }

    private void validateRepeat(CustomerRequest customerRequest) {
        LambdaQueryWrapper accountWrapper = new LambdaQueryWrapper();
        accountWrapper.eq(Customer::getAccount, (Object)customerRequest.getAccount());
        int count = this.count((Wrapper)accountWrapper);
        if (count > 0) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.ACCOUNT_REPEAT);
        }
        LambdaQueryWrapper emailWrapper = new LambdaQueryWrapper();
        emailWrapper.eq(Customer::getEmail, (Object)customerRequest.getEmail());
        int emailCount = this.count((Wrapper)emailWrapper);
        if (emailCount > 0) {
            throw new CustomerException((AbstractExceptionEnum)CustomerExceptionEnum.EMAIL_REPEAT);
        }
    }

    private void validateDragCaptcha(String verKey, String verCode) {
        if (SecurityConfigExpander.getDragCaptchaOpen().booleanValue()) {
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.dragCaptchaApi.validateCaptcha(verKey, Convert.toInt((Object)verCode))) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.DRAG_CAPTCHA_ERROR);
            }
        }
    }
}

