/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.cache.redis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractRedisCacheOperator<T>
implements CacheOperatorApi<T> {
    private final RedisTemplate<String, T> redisTemplate;

    public AbstractRedisCacheOperator(RedisTemplate<String, T> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void put(String key, T value) {
        this.redisTemplate.boundValueOps((Object)this.calcKey(key)).set(value);
    }

    public void put(String key, T value, Long timeoutSeconds) {
        this.redisTemplate.boundValueOps((Object)this.calcKey(key)).set(value, timeoutSeconds.longValue(), TimeUnit.SECONDS);
    }

    public T get(String key) {
        return (T)this.redisTemplate.boundValueOps((Object)this.calcKey(key)).get();
    }

    public void remove(String ... key) {
        ArrayList keys = CollectionUtil.toList((Object[])key);
        List withPrefixKeys = keys.stream().map(arg_0 -> ((AbstractRedisCacheOperator)this).calcKey(arg_0)).collect(Collectors.toList());
        this.redisTemplate.delete(withPrefixKeys);
    }

    public void expire(String key, Long expiredSeconds) {
        this.redisTemplate.boundValueOps((Object)this.calcKey(key)).expire(expiredSeconds.longValue(), TimeUnit.SECONDS);
    }

    public boolean contains(String key) {
        Object value = this.redisTemplate.boundValueOps((Object)this.calcKey(key)).get();
        return value != null;
    }

    public Collection<String> getAllKeys() {
        Set keys = this.redisTemplate.keys((Object)(this.getFinalPrefix() + "*"));
        if (keys != null) {
            return keys.stream().map(arg_0 -> ((AbstractRedisCacheOperator)this).removePrefix(arg_0)).collect(Collectors.toSet());
        }
        return CollectionUtil.newHashSet((Object[])new String[0]);
    }

    public Collection<T> getAllValues() {
        Set keys = this.redisTemplate.keys((Object)(this.getCommonKeyPrefix() + "*"));
        if (keys != null) {
            return this.redisTemplate.opsForValue().multiGet((Collection)keys);
        }
        return CollectionUtil.newArrayList((Object[])new Object[0]);
    }

    public Map<String, T> getAllKeyValues() {
        Collection<String> allKeys = this.getAllKeys();
        HashMap results = MapUtil.newHashMap();
        for (String key : allKeys) {
            results.put(key, this.get(key));
        }
        return results;
    }

    public RedisTemplate<String, T> getRedisTemplate() {
        return this.redisTemplate;
    }
}

