/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.cache.redis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractRedisHashCacheOperator<T>
implements CacheOperatorApi<T> {
    private final RedisTemplate<String, T> redisTemplate;

    public AbstractRedisHashCacheOperator(RedisTemplate<String, T> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void put(String key, T value) {
        this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).put((Object)key, value);
    }

    public void put(String key, T value, Long timeoutSeconds) {
        this.put(key, value);
    }

    public T get(String key) {
        return (T)this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).get((Object)key);
    }

    public void remove(String ... key) {
        this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).delete((Object[])key);
    }

    public void expire(String key, Long expiredSeconds) {
        this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).expire(expiredSeconds.longValue(), TimeUnit.SECONDS);
    }

    public boolean contains(String key) {
        return this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).hasKey((Object)key);
    }

    public Collection<String> getAllKeys() {
        Set keys = this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).keys();
        if (keys != null) {
            return keys.stream().map(Object::toString).collect(Collectors.toSet());
        }
        return CollectionUtil.newHashSet((Object[])new String[0]);
    }

    public Collection<T> getAllValues() {
        Collection<String> allKeys = this.getAllKeys();
        if (allKeys != null) {
            return this.redisTemplate.boundHashOps((Object)this.getCommonKeyPrefix()).multiGet(Collections.singleton(allKeys));
        }
        return CollectionUtil.newArrayList((Object[])new Object[0]);
    }

    public Map<String, T> getAllKeyValues() {
        Collection<String> allKeys = this.getAllKeys();
        HashMap results = MapUtil.newHashMap();
        for (String key : allKeys) {
            results.put(key, this.get(key));
        }
        return results;
    }

    public RedisTemplate<String, T> getRedisTemplate() {
        return this.redisTemplate;
    }
}

