/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.cache.memory;

import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMemoryCacheOperator<T>
implements CacheOperatorApi<T> {
    private final TimedCache<String, T> timedCache;

    public AbstractMemoryCacheOperator(TimedCache<String, T> timedCache) {
        this.timedCache = timedCache;
    }

    public void put(String key, T value) {
        this.timedCache.put((Object)(this.getCommonKeyPrefix() + key), value);
    }

    public void put(String key, T value, Long timeoutSeconds) {
        this.timedCache.put((Object)(this.getCommonKeyPrefix() + key), value, timeoutSeconds * 1000L);
    }

    public T get(String key) {
        return (T)this.timedCache.get((Object)(this.getCommonKeyPrefix() + key), true);
    }

    public void remove(String ... key) {
        if (key.length > 0) {
            for (String itemKey : key) {
                this.timedCache.remove((Object)(this.getCommonKeyPrefix() + itemKey));
            }
        }
    }

    public void expire(String key, Long expiredSeconds) {
        Object value = this.timedCache.get((Object)(this.getCommonKeyPrefix() + key), true);
        this.timedCache.put((Object)(this.getCommonKeyPrefix() + key), value, expiredSeconds * 1000L);
    }

    public boolean contains(String key) {
        return this.timedCache.containsKey((Object)(this.getCommonKeyPrefix() + key));
    }

    public Collection<String> getAllKeys() {
        Iterator cacheObjIterator = this.timedCache.cacheObjIterator();
        ArrayList keys = CollectionUtil.newArrayList((Object[])new String[0]);
        while (cacheObjIterator.hasNext()) {
            String key = (String)((CacheObj)cacheObjIterator.next()).getKey();
            keys.add(StrUtil.removePrefix((CharSequence)key, (CharSequence)this.getCommonKeyPrefix()));
        }
        return keys;
    }

    public Collection<T> getAllValues() {
        Iterator cacheObjIterator = this.timedCache.cacheObjIterator();
        ArrayList values = CollectionUtil.newArrayList((Object[])new Object[0]);
        while (cacheObjIterator.hasNext()) {
            values.add(((CacheObj)cacheObjIterator.next()).getValue());
        }
        return values;
    }

    public Map<String, T> getAllKeyValues() {
        Collection<String> allKeys = this.getAllKeys();
        HashMap results = CollectionUtil.newHashMap();
        for (String key : allKeys) {
            results.put(key, this.get(key));
        }
        return results;
    }
}

