/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.starter;

import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.TenantCodeGetApi;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordTransferEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.PwdRsaSecretProperties;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.auth.DefaultTenantCodeProvider;
import cn.stylefeng.roses.kernel.auth.password.BcryptPasswordStoredEncrypt;
import cn.stylefeng.roses.kernel.auth.password.RsaPasswordTransferEncrypt;
import cn.stylefeng.roses.kernel.auth.session.DefaultSessionManager;
import cn.stylefeng.roses.kernel.auth.session.timer.ClearInvalidLoginUserCacheTimer;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.jwt.JwtTokenOperator;
import cn.stylefeng.roses.kernel.jwt.api.JwtApi;
import cn.stylefeng.roses.kernel.jwt.api.pojo.config.JwtConfig;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthAutoConfiguration {
    @Resource
    private PwdRsaSecretProperties pwdRsaSecretProperties;

    @Bean
    @ConditionalOnMissingBean(value={JwtApi.class})
    public JwtApi jwtApi() {
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setJwtSecret(AuthConfigExpander.getAuthJwtSecret());
        jwtConfig.setExpiredSeconds(AuthConfigExpander.getAuthJwtTimeoutSeconds());
        return new JwtTokenOperator(jwtConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordStoredEncryptApi.class})
    public PasswordStoredEncryptApi passwordStoredEncryptApi() {
        return new BcryptPasswordStoredEncrypt();
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordTransferEncryptApi.class})
    public PasswordTransferEncryptApi passwordTransferEncryptApi() {
        return new RsaPasswordTransferEncrypt(this.pwdRsaSecretProperties.getPublicKey(), this.pwdRsaSecretProperties.getPrivateKey());
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionManagerApi.class})
    public SessionManagerApi sessionManagerApi(CacheOperatorApi<LoginUser> loginUserCache, CacheOperatorApi<Set<String>> allPlaceLoginTokenCache) {
        Long sessionExpiredSeconds = AuthConfigExpander.getSessionExpiredSeconds();
        return new DefaultSessionManager(loginUserCache, allPlaceLoginTokenCache, sessionExpiredSeconds);
    }

    @Bean
    @ConditionalOnMissingBean(value={ClearInvalidLoginUserCacheTimer.class})
    public ClearInvalidLoginUserCacheTimer clearInvalidLoginUserCacheTimer(CacheOperatorApi<LoginUser> loginUserCache, CacheOperatorApi<Set<String>> allPlaceLoginTokenCache) {
        return new ClearInvalidLoginUserCacheTimer(loginUserCache, allPlaceLoginTokenCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantCodeGetApi.class})
    public TenantCodeGetApi tenantCodeGetApi() {
        return new DefaultTenantCodeProvider();
    }
}

