/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.starter.cache;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.auth.api.constants.LoginCacheConstants;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.cache.LoginErrorCountMemoryCache;
import cn.stylefeng.roses.kernel.auth.session.cache.catoken.MemoryCaClientTokenCache;
import cn.stylefeng.roses.kernel.auth.session.cache.logintoken.MemoryLoginTokenCache;
import cn.stylefeng.roses.kernel.auth.session.cache.loginuser.MemoryLoginUserCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.api.constants.CacheConstants;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class AuthTokenMemoryCacheAutoConfiguration {
    @Bean
    public CacheOperatorApi<LoginUser> loginUserCache() {
        Long sessionExpiredSeconds = AuthConfigExpander.getSessionExpiredSeconds();
        TimedCache loginUsers = CacheUtil.newTimedCache((long)(1000L * sessionExpiredSeconds));
        return new MemoryLoginUserCache(loginUsers);
    }

    @Bean
    public CacheOperatorApi<Set<String>> allPlaceLoginTokenCache() {
        TimedCache loginTokens = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        return new MemoryLoginTokenCache(loginTokens);
    }

    @Bean
    public CacheOperatorApi<Integer> loginErrorCountCacheApi() {
        TimedCache loginTimeCache = CacheUtil.newTimedCache((long)(LoginCacheConstants.LOGIN_CACHE_TIMEOUT_SECONDS * 1000L));
        return new LoginErrorCountMemoryCache(loginTimeCache);
    }

    @Bean
    public CacheOperatorApi<String> caClientTokenCacheApi() {
        TimedCache loginTimeCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        return new MemoryCaClientTokenCache(loginTimeCache);
    }
}

