/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.api.expander;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.constants.AuthConstants;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import java.util.ArrayList;
import java.util.List;

public class AuthConfigExpander {
    public static List<String> getNoneSecurityConfig() {
        String noneSecurityUrls = (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_NONE_SECURITY_URLS", String.class, (Object)"");
        if (StrUtil.isEmpty((CharSequence)noneSecurityUrls)) {
            return new ArrayList<String>();
        }
        return StrUtil.split((CharSequence)noneSecurityUrls, (char)',');
    }

    public static String getAuthJwtSecret() {
        String sysJwtSecret = (String)ConfigContext.me().getConfigValueNullable("SYS_AUTH_JWT_SECRET", String.class);
        if (sysJwtSecret == null) {
            return RandomUtil.randomString((int)20);
        }
        return sysJwtSecret;
    }

    public static Long getAuthJwtTimeoutSeconds() {
        return (Long)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_JWT_TIMEOUT_SECONDS", Long.class, (Object)AuthConstants.DEFAULT_AUTH_JWT_TIMEOUT_SECONDS);
    }

    public static Long getSessionExpiredSeconds() {
        return (Long)ConfigContext.me().getSysConfigValueWithDefault("SYS_SESSION_EXPIRED_SECONDS", Long.class, (Object)3600L);
    }

    public static boolean getSingleAccountLoginFlag() {
        return (Boolean)ConfigContext.me().getSysConfigValueWithDefault("SYS_SINGLE_ACCOUNT_LOGIN_FLAG", Boolean.class, (Object)false);
    }

    public static String getSsoJwtSecret() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_JWT_SECRET", String.class, (Object)"aabbccdd");
    }

    public static String getSsoDataDecryptSecret() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_DECRYPT_DATA_SECRET", String.class, (Object)"EDPpR/BQfEFJiXKgxN8Uno4OnNMGcIJW1F777yySCPA=");
    }

    public static Boolean getSsoSessionValidateSwitch() {
        return (Boolean)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_SESSION_VALIDATE_SWITCH", Boolean.class, (Object)AuthConstants.SYS_AUTH_SSO_SESSION_VALIDATE_SWITCH);
    }

    public static String getSsoSessionValidateRedisHost() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_HOST", String.class, (Object)"localhost");
    }

    public static Integer getSsoSessionValidateRedisPort() {
        return (Integer)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_PORT", Integer.class, (Object)AuthConstants.SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_PORT);
    }

    public static String getSsoSessionValidateRedisPassword() {
        return (String)ConfigContext.me().getConfigValueNullable("SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_PASSWORD", String.class);
    }

    public static Integer getSsoSessionValidateRedisDbIndex() {
        return (Integer)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_DB_INDEX", Integer.class, (Object)AuthConstants.SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_DB_INDEX);
    }

    public static String getSsoSessionValidateRedisCachePrefix() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_SESSION_VALIDATE_REDIS_CACHE_PREFIX", String.class, (Object)"CA:USER:TOKEN:");
    }

    public static String getSsoUrl() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_SSO_HOST", String.class, (Object)"http://localhost:8888");
    }

    public static Boolean getPasswordRsaValidateFlag() {
        return (Boolean)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_PASSWORD_RSA_VALIDATE", Boolean.class, (Object)false);
    }
}

