/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.api.expander;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.constants.AuthConstants;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import java.util.ArrayList;
import java.util.List;

public class AuthConfigExpander {
    public static List<String> getNoneSecurityConfig() {
        String noneSecurityUrls = (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_NONE_SECURITY_URLS", String.class, (Object)"");
        if (StrUtil.isEmpty((CharSequence)noneSecurityUrls)) {
            return new ArrayList<String>();
        }
        return StrUtil.split((CharSequence)noneSecurityUrls, (char)',');
    }

    public static String getAuthJwtSecret() {
        String sysJwtSecret = (String)ConfigContext.me().getConfigValueNullable("SYS_AUTH_JWT_SECRET", String.class);
        if (sysJwtSecret == null) {
            return RandomUtil.randomString((int)20);
        }
        return sysJwtSecret;
    }

    public static Long getAuthJwtTimeoutSeconds() {
        return (Long)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_JWT_TIMEOUT_SECONDS", Long.class, (Object)AuthConstants.DEFAULT_AUTH_JWT_TIMEOUT_SECONDS);
    }

    public static Long getSessionExpiredSeconds() {
        return (Long)ConfigContext.me().getSysConfigValueWithDefault("SYS_SESSION_EXPIRED_SECONDS", Long.class, (Object)3600L);
    }

    public static boolean getSingleAccountLoginFlag() {
        return (Boolean)ConfigContext.me().getSysConfigValueWithDefault("SYS_SINGLE_ACCOUNT_LOGIN_FLAG", Boolean.class, (Object)false);
    }

    public static String getAuthTokenHeaderName() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_HEADER_NAME", String.class, (Object)"Authorization");
    }

    public static String getAuthTokenParamName() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_AUTH_PARAM_NAME", String.class, (Object)"token");
    }

    public static String getSessionCookieName() {
        return (String)ConfigContext.me().getSysConfigValueWithDefault("SYS_SESSION_COOKIE_NAME", String.class, (Object)"Authorization");
    }
}

