/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.redis.lock;

import cn.structure.starter.redis.lock.IDistributedLock;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public class RedisDistributedLockImpl
implements IDistributedLock {
    private final Logger logger = LoggerFactory.getLogger(RedisDistributedLockImpl.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final ThreadLocal<String> lockFlag = new ThreadLocal();

    public RedisDistributedLockImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        boolean result = this.setRedis(key, expire);
        while (!result && retryTimes-- > 0) {
            try {
                this.logger.debug("lock failed, retrying...{}", (Object)retryTimes);
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                return false;
            }
            result = this.setRedis(key, expire);
        }
        return result;
    }

    private boolean setRedis(String key, long expire) {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(key);
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(this.lockFlag.get());
            args.add(expire);
            DefaultRedisScript script = new DefaultRedisScript();
            script.setResultType(Long.class);
            script.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("script/lock.lua")));
            Long execute = (Long)this.redisTemplate.execute((RedisScript)script, keys, new Object[]{args});
            return execute != null && execute > 0L;
        }
        catch (Exception e) {
            this.logger.error("set redis proceed an exception", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean releaseLock(String key) {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(key);
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.lockFlag.get());
            DefaultRedisScript script = new DefaultRedisScript();
            script.setResultType(Long.class);
            script.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("script/unLock.lua")));
            Long execute = (Long)this.redisTemplate.execute((RedisScript)script, keys, new Object[]{args});
            return execute != null && execute > 0L;
        }
        catch (Exception e) {
            this.logger.error("release lock proceed an exception", (Throwable)e);
            return false;
        }
    }
}

