/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.redis.configuration;

import cn.structure.starter.redis.annotation.RedisLock;
import cn.structure.starter.redis.lock.IDistributedLock;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
@Configuration
public class DistributedLockAspectConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DistributedLockAspectConfiguration.class);
    @Resource
    private IDistributedLock distributedLock;

    @Pointcut(value="@annotation(cn.structure.starter.redis.annotation.RedisLock)")
    private void lockPoint() {
    }

    public static String getValueBySpelKey(String key, String[] parameterNames, Object[] values) {
        if (!key.contains("#")) {
            return key;
        }
        String[] spelKeys = key.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= spelKeys.length - 1; ++i) {
            if (!spelKeys[i].startsWith("#")) {
                sb.append(spelKeys[i]);
                continue;
            }
            String tempKey = spelKeys[i];
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int j = 0; j < parameterNames.length; ++j) {
                context.setVariable(parameterNames[j], values[j]);
            }
            Expression expression = parser.parseExpression(tempKey);
            Object value = expression.getValue((EvaluationContext)context);
            if (value == null) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="lockPoint()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        RedisLock redisLock = method.getAnnotation(RedisLock.class);
        String[] parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(((MethodSignature)pjp.getSignature()).getMethod());
        Object[] args = pjp.getArgs();
        String key = DistributedLockAspectConfiguration.getValueBySpelKey(redisLock.value(), parameterNames, args);
        int retryTimes = redisLock.action().equals((Object)RedisLock.LockFailAction.CONTINUE) ? redisLock.retryTimes() : 0;
        boolean lock = this.distributedLock.lock(key, redisLock.keepMills(), retryTimes, redisLock.sleepMills());
        if (!lock) {
            this.logger.debug("get lock failed : {}", (Object)key);
            return null;
        }
        this.logger.debug("get lock success : {}", (Object)key);
        try {
            object = pjp.proceed();
            boolean releaseResult = this.distributedLock.releaseLock(key);
            this.logger.debug("release lock : {}{}", (Object)key, (Object)(releaseResult ? " success" : " failed"));
        }
        catch (Exception e) {
            try {
                this.logger.error("execute locked method proceed an exception", (Throwable)e);
                boolean releaseResult = this.distributedLock.releaseLock(key);
                this.logger.debug("release lock : {}{}", (Object)key, (Object)(releaseResult ? " success" : " failed"));
            }
            catch (Throwable throwable) {
                boolean releaseResult = this.distributedLock.releaseLock(key);
                this.logger.debug("release lock : {}{}", (Object)key, (Object)(releaseResult ? " success" : " failed"));
                throw throwable;
            }
            return null;
        }
        return object;
    }
}

