/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.jwt.filter;

import cn.structure.starter.jwt.entity.AuthUser;
import cn.structure.starter.jwt.interfaces.ITokenService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class LoginFilter
extends AbstractAuthenticationProcessingFilter {
    private ITokenService tokenService;

    public LoginFilter(ITokenService tokenService) {
        super((RequestMatcher)new AntPathRequestMatcher("/login", "POST"));
        this.tokenService = tokenService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        UsernamePasswordAuthenticationToken params = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        Authentication authenticate = authenticationManager.authenticate((Authentication)params);
        AuthUser details = (AuthUser)authenticate.getPrincipal();
        String token = this.tokenService.generateToken(details);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(token);
        return authenticate;
    }
}

