/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.jwt.configuration;

import cn.structure.common.enums.NumberEnum;
import cn.structure.starter.jwt.configuration.ICorsFilter;
import cn.structure.starter.jwt.configuration.JwtRequestFilter;
import cn.structure.starter.jwt.interfaces.ITokenService;
import cn.structure.starter.jwt.properties.JwtConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AuthenticationEntryPoint jwtAuthenticationEntryPoint;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private JwtRequestFilter jwtRequestFilter;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JwtConfig jwtConfig;
    @Autowired
    private ITokenService iTokenService;
    @Autowired
    private ICorsFilter corsFilter;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity)httpSecurity.csrf().disable()).authorizeRequests();
        Map<String, List<String>> antMatchers = this.jwtConfig.getAntMatchers();
        if (antMatchers != null) {
            Set<String> keys = antMatchers.keySet();
            for (String key : keys) {
                if (key.equals("unAuthenticated")) {
                    List<String> urls = antMatchers.get(key);
                    for (String url : urls) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)httpSecurity.csrf().disable()).authorizeRequests().antMatchers(new String[]{url})).permitAll();
                    }
                    continue;
                }
                String[] authUrlStr = key.split("-");
                if (authUrlStr.length < NumberEnum.TWO.getValue()) continue;
                String type = authUrlStr[NumberEnum.ZERO.getValue()];
                String str = authUrlStr[NumberEnum.ONE.getValue()];
                List<String> urls = antMatchers.get(key);
                if (type.equals("role")) {
                    for (String url : urls) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)httpSecurity.csrf().disable()).authorizeRequests().antMatchers(new String[]{url})).hasRole(str);
                    }
                }
                if (!type.equals("auth")) continue;
                for (String url : urls) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)httpSecurity.csrf().disable()).authorizeRequests().antMatchers(new String[]{url})).hasAuthority(str);
                }
            }
        }
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)httpSecurity.authorizeRequests().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint(this.jwtAuthenticationEntryPoint).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        httpSecurity.addFilterBefore((Filter)this.jwtRequestFilter, UsernamePasswordAuthenticationFilter.class);
        httpSecurity.addFilterBefore((Filter)this.corsFilter, JwtRequestFilter.class);
    }
}

