/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.jwt.configuration;

import cn.structure.starter.jwt.entity.AuthUser;
import cn.structure.starter.jwt.interfaces.ITokenService;
import cn.structure.starter.jwt.properties.JwtConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@ConditionalOnClass(value={JwtConfig.class})
public class JwtRequestFilter
extends OncePerRequestFilter {
    @Autowired
    private ITokenService iTokenService;
    @Autowired
    private JwtConfig jwtConfig;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        Map<String, List<String>> antMatchers = this.jwtConfig.getAntMatchers();
        List<String> unAuthenticated = antMatchers.get("unAuthenticated");
        AntPathMatcher matcher = new AntPathMatcher();
        for (String uri : unAuthenticated) {
            if (!matcher.match(uri, requestUri)) continue;
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = this.getToken(request);
        if (token == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuthUser user = this.iTokenService.getUserInfoFromToken(token);
        if (user == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.iTokenService.isTokenExpired(token).booleanValue()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getToken(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ")) {
            return header.replace("Bearer ", "");
        }
        return null;
    }
}

