/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.jwt.configuration;

import cn.structure.starter.jwt.entity.AuthUser;
import cn.structure.starter.jwt.interfaces.ITokenService;
import cn.structure.starter.jwt.properties.JwtConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtDefaultServiceImpl
implements ITokenService {
    private JwtConfig jwtConfig;

    @Override
    public AuthUser getUserInfoFromToken(String token) {
        Claims claims = this.getAllClaimsFromToken(token);
        return new AuthUser((Serializable)((Object)((String)claims.get((Object)"id"))), (String)claims.get((Object)"username"));
    }

    @Override
    public Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtConfig.getSecret()).parseClaimsJws(token).getBody();
    }

    @Override
    public Boolean isTokenExpired(String token) {
        Claims claims = this.getAllClaimsFromToken(token);
        Date expiration = claims.getExpiration();
        return expiration.before(new Date());
    }

    @Override
    public String generateToken(AuthUser userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("id", userDetails.getId());
        claims.put("username", userDetails.getUsername());
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    @Override
    public String doGenerateToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + this.jwtConfig.getJwtTokenValidity() * 1000L)).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getSecret()).compact();
    }

    public JwtDefaultServiceImpl() {
    }

    public JwtDefaultServiceImpl(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }
}

