/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.starter.jwt.configuration;

import cn.structure.starter.jwt.configuration.CorsFilter;
import cn.structure.starter.jwt.configuration.ICorsFilter;
import cn.structure.starter.jwt.configuration.JwtAuthenticationEntryPoint;
import cn.structure.starter.jwt.configuration.JwtDefaultServiceImpl;
import cn.structure.starter.jwt.interfaces.ITokenService;
import cn.structure.starter.jwt.properties.JwtConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;

@Configuration
@EnableConfigurationProperties(value={JwtConfig.class})
@ComponentScan(value={"cn.structure.starter.jwt.configuration", "cn.structure.starter.jwt.filter"})
public class AutoConfiguration {
    @Autowired
    private JwtConfig jwtConfig;

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationEntryPoint.class})
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new JwtAuthenticationEntryPoint();
    }

    @Bean
    @ConditionalOnMissingBean(value={ITokenService.class})
    public ITokenService tokenService() {
        return new JwtDefaultServiceImpl(this.jwtConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={ICorsFilter.class})
    public ICorsFilter corsFilter() {
        return new CorsFilter();
    }
}

