/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.common.utils;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(str.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static String unicode2String(String unicode) {
        StringBuilder string = new StringBuilder();
        String[] hex = unicode.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String trimAndRemoveQuot(String str) {
        return str.replaceAll("['*]*", "").trim();
    }

    public static String removeAllBlankAndQuot(String str) {
        return str.replaceAll("['*| *|\u3000*|\\s*]*", "").trim();
    }

    public static String maskReplaceStar(String phone) {
        String result = null;
        if (!StringUtil.isBlank(phone)) {
            if (phone.length() < 7) {
                result = phone;
            } else {
                String start = phone.substring(0, 3);
                String end = phone.substring(phone.length() - 4, phone.length());
                result = start + "****" + end;
            }
        }
        return result;
    }
}

