/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.common.utils;

import cn.structure.common.utils.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_YYYY = "yyyy";
    public static final String DATE_FORMAT_YYYYMM = "yyyyMM";
    public static final String DATE_FORMAT_YYYY_MM = "yyyy-MM";
    public static final String DATE_FORMAT_YYMMDD = "yyMMdd";
    public static final String DATE_FORMAT_YY_MM_DD = "yy-MM-dd";
    public static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_FORMAT_POINTYYYYMMDD = "yyyy.MM.dd";
    public static final String DATE_TIME_FORMAT_YYYY\u5e74MM\u6708DD\u65e5 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_YYYYMMDDHHmm = "yyyyMMddHHmm";
    public static final String DATE_TIME_FORMAT_YYYYMMDD_HH_MI = "yyyyMMdd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI = "yyyy-MM-dd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISS = "yyyyMMddHHmmss";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISSSSS = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_MMDDHHMI = "MM-dd HH:mm";
    public static final String YMD = "yyyyMMdd";
    public static final String YMD_YEAR = "yyyy";
    public static final String YMD_BREAK = "yyyy-MM-dd";
    public static final String YMDHMS = "yyyyMMddHHmmss";
    public static final String YMDHMS_BREAK = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHMS_BREAK_HALF = "yyyy-MM-dd HH:mm";
    public static final String PP = "YYYY\u5e74MM\u6708dd\u65e5";
    public static final long CAL_MINUTES = 60000L;
    public static final long CAL_HOURS = 3600000L;
    public static final long CAL_DAYS = 86400000L;
    public static final long CAL_MONTHS = 2592000000L;

    public static String getNowDateText(String pattern) {
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat(pattern);
        return sdf.format(new Date());
    }

    public static String getDateText(Date date, String pattern) {
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date getDate(String date, String pattern) throws ParseException {
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat(pattern);
        return sdf.parse(date);
    }

    private static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Long getTime(Date date) {
        return date.getTime();
    }

    public static int calDiffs(Date startDate, Date endDate, long calType) {
        Long start = DateUtil.getTime(startDate);
        Long end = DateUtil.getTime(endDate);
        int diff = (int)((end - start) / calType);
        return diff;
    }

    public static String timeDiffText(Date startDate, Date endDate) {
        long calDiffs = DateUtil.calDiffs(startDate, endDate, 60000L);
        if (calDiffs == 0L) {
            return "\u521a\u521a";
        }
        if (calDiffs < 60L) {
            return calDiffs + "\u5206\u949f\u524d";
        }
        calDiffs = DateUtil.calDiffs(startDate, endDate, 3600000L);
        if (calDiffs < 24L) {
            return calDiffs + "\u5c0f\u65f6\u524d";
        }
        calDiffs = DateUtil.calDiffs(startDate, endDate, 86400000L);
        if (calDiffs < 4L) {
            return calDiffs + "\u5929\u524d";
        }
        return DateUtil.parseDateToStr(startDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static String showTimeText(Date date) {
        return DateUtil.timeDiffText(date, new Date());
    }

    public static String parseDateToStr(Date time, String timeFromat) {
        if (null == time) {
            time = new Date();
        }
        if (StringUtil.isBlank(timeFromat)) {
            timeFromat = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeFromat);
        return dateFormat.format(time);
    }

    public static Date toDate(long time) {
        if ("".equals(time)) {
            return new Date();
        }
        Date date = new Date(time);
        return date;
    }

    public static long toLong(Date date) {
        if (date == null) {
            return 0L;
        }
        long d = date.getTime();
        return d;
    }

    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Date add(int field, Date date, int value) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(field, value);
        Date newDate = ca.getTime();
        return newDate;
    }

    public static Date getWeekStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        return mondayDate;
    }

    public static Date getTodayStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        return date;
    }
}

