/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.common.entity;

import cn.structure.common.entity.VerificationFailedMsg;
import cn.structure.common.enums.ResultCodeEnum;
import cn.structure.common.exception.CommonException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel(description="\u51fa\u53c2 \uff1a \u8fd4\u56de\u7ed3\u679c\u5c01\u88c5 - VO")
public class ResultVO<T>
implements Serializable {
    @ApiModelProperty(value="\u7cfb\u7edf\u7ea7\u522b\u7684CODE\u7801", example="SUCCESS")
    private String code;
    @ApiModelProperty(value="\u7cfb\u7edf\u7ea7\u522b\u7684\u6d88\u606f\u5185\u5bb9", example="\u6210\u529f\uff01")
    private String msg;
    @ApiModelProperty(value="\u4e1a\u52a1\u7ea7\u522b\u7684code\u7801", example="SUCCESS")
    private String subCode;
    @ApiModelProperty(value="\u4e1a\u52a1\u7ea7\u522b\u7684\u6d88\u606f\u5185\u5bb9", example="\u6210\u529f\uff01")
    private String subMsg;
    @ApiModelProperty(value="\u7cfb\u7edf\u54cd\u5e94\u7684\u65f6\u95f4\u6233", example="112345644446")
    private long timestamp;
    @ApiModelProperty(value="\u7cfb\u7edf\u54cd\u5e94\u7684\u56de\u53c2\u6570\u636e\u662f\u4e00\u4e2a\u6cdb\u578b", example="{}")
    private T data;

    public static <T> ResultVO success() {
        ResultVO<Object> result = new ResultVO<Object>(ResultCodeEnum.SUCCESS.getCode(), ResultCodeEnum.SUCCESS.getMsg(), ResultCodeEnum.SUCCESS.getCode(), ResultCodeEnum.SUCCESS.getMsg(), new Date().getTime(), null);
        return result;
    }

    public static <T> ResultVO<T> success(T d) {
        return ResultVO.builder(d).code(ResultCodeEnum.SUCCESS.getCode()).msg(ResultCodeEnum.SUCCESS.getMsg()).subCode(ResultCodeEnum.SUCCESS.getCode()).timestamp(new Date().getTime()).build();
    }

    public static ResultVO exception(String message) {
        return ResultVO.builder().code(ResultCodeEnum.ERR.getCode()).msg(message).timestamp(new Date().getTime()).build();
    }

    public static ResultVO exception(CommonException ce) {
        return ResultVO.builder().code(ResultCodeEnum.ERR.getCode()).msg(ce.getMessage()).subCode(ce.getCode()).subMsg(ce.getMsg()).timestamp(new Date().getTime()).build();
    }

    public static ResultVO exception(String msg, String subCode, String subMsg) {
        return ResultVO.builder().code(ResultCodeEnum.ERR.getCode()).msg(msg).subCode(subCode).subMsg(subMsg).timestamp(new Date().getTime()).build();
    }

    public static ResultVO fail(String subCode, String subMsg) {
        return ResultVO.builder().code(ResultCodeEnum.FAIL.getCode()).msg(ResultCodeEnum.FAIL.getMsg()).subCode(subCode).subMsg(subMsg).timestamp(new Date().getTime()).data(null).build();
    }

    public static ResultVO fail(Integer subCode, String subMsg) {
        return ResultVO.builder().code(ResultCodeEnum.FAIL.getCode()).msg(ResultCodeEnum.FAIL.getMsg()).subCode(subCode + "").subMsg(subMsg).timestamp(new Date().getTime()).data(null).build();
    }

    public static <T> ResultVO<T> fail(String subCode, String subMsg, T d) {
        return ResultVO.builder(d).code(ResultCodeEnum.SUCCESS.getCode()).msg(ResultCodeEnum.SUCCESS.getMsg()).subCode(subCode).subMsg(subMsg).timestamp(new Date().getTime()).data(d).build();
    }

    public static ResultVO fallback(String subCode, String subMsg) {
        return ResultVO.builder().code(ResultCodeEnum.FALLBACK.getCode()).msg(ResultCodeEnum.FALLBACK.getMsg()).subCode(subCode).subMsg(subMsg).timestamp(new Date().getTime()).build();
    }

    public static ResultVO unauthorized() {
        return ResultVO.builder().code(ResultCodeEnum.UNAUTHORIZED.getCode()).msg(ResultCodeEnum.UNAUTHORIZED.getMsg()).timestamp(new Date().getTime()).build();
    }

    public static ResultVO unauthorized(String subCode, String subMsg) {
        return ResultVO.builder().code(ResultCodeEnum.UNAUTHORIZED.getCode()).msg(ResultCodeEnum.UNAUTHORIZED.getMsg()).subCode(subCode).subMsg(subMsg).timestamp(new Date().getTime()).build();
    }

    public static ResultVO verificationFailed(List<VerificationFailedMsg> verificationFailedMsgList) {
        return ResultVO.builder().code(ResultCodeEnum.VERIFICATION_FAILED.getCode()).msg(ResultCodeEnum.VERIFICATION_FAILED.getMsg()).timestamp(new Date().getTime()).data(verificationFailedMsgList).build();
    }

    public static ResultVO notfound() {
        return ResultVO.builder().code(ResultCodeEnum.NOT_FOUND.getCode()).msg(ResultCodeEnum.NOT_FOUND.getMsg()).timestamp(new Date().getTime()).build();
    }

    public boolean isSuccess() {
        return this.code.equals(ResultCodeEnum.SUCCESS.getCode()) && this.subCode.equals(ResultCodeEnum.SUCCESS.getCode());
    }

    public boolean isFail() {
        return !this.isSuccess();
    }

    public static boolean isSuccess(ResultVO r) {
        return r.code.equals(ResultCodeEnum.SUCCESS.getCode()) && r.subCode.equals(ResultCodeEnum.SUCCESS.getCode());
    }

    public static boolean isFail(ResultVO r) {
        return !ResultVO.isSuccess(r);
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public static <T> ResultBuilder<T> builder(T t) {
        return new ResultBuilder<T>(t);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVO;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public String getSubMsg() {
        return this.subMsg;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public void setSubMsg(String subMsg) {
        this.subMsg = subMsg;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "ResultVO(code=" + this.getCode() + ", msg=" + this.getMsg() + ", subCode=" + this.getSubCode() + ", subMsg=" + this.getSubMsg() + ", timestamp=" + this.getTimestamp() + ", data=" + this.getData() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVO)) {
            return false;
        }
        ResultVO other = (ResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$subCode = this.getSubCode();
        String other$subCode = other.getSubCode();
        if (this$subCode == null ? other$subCode != null : !this$subCode.equals(other$subCode)) {
            return false;
        }
        String this$subMsg = this.getSubMsg();
        String other$subMsg = other.getSubMsg();
        if (this$subMsg == null ? other$subMsg != null : !this$subMsg.equals(other$subMsg)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $subCode = this.getSubCode();
        result = result * 59 + ($subCode == null ? 43 : $subCode.hashCode());
        String $subMsg = this.getSubMsg();
        result = result * 59 + ($subMsg == null ? 43 : $subMsg.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public ResultVO() {
    }

    public ResultVO(String code, String msg, String subCode, String subMsg, long timestamp, T data) {
        this.code = code;
        this.msg = msg;
        this.subCode = subCode;
        this.subMsg = subMsg;
        this.timestamp = timestamp;
        this.data = data;
    }

    public static class ResultBuilder<T> {
        private String code;
        private String msg;
        private String subCode;
        private String subMsg;
        private long timestamp;
        private T data;

        ResultBuilder() {
        }

        ResultBuilder(T t) {
            this.data = t;
        }

        public ResultBuilder<T> code(String code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ResultBuilder<T> subCode(String subCode) {
            this.subCode = subCode;
            return this;
        }

        public ResultBuilder<T> subMsg(String subMsg) {
            this.subMsg = subMsg;
            return this;
        }

        public ResultBuilder<T> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultVO<T> build() {
            return new ResultVO<T>(this.code, this.msg, this.subCode, this.subMsg, this.timestamp, this.data);
        }
    }
}

