/*
 * Decompiled with CFR 0.152.
 */
package cn.structure.common.entity;

import cn.structure.common.enums.ExceptionRsType;
import cn.structure.common.enums.ResultCodeEnum;
import cn.structure.common.exception.CommonException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="\u51fa\u53c2\uff1a\u8fd4\u56de\u7ed3\u679c - VO")
public class ResResultVO<T> {
    @ApiModelProperty(value="\u4e1a\u52a1\u72b6\u6001\u7801", example="SUCCESS")
    private String code;
    @ApiModelProperty(value="\u8fd4\u56de\u7684\u6d88\u606f\u5185\u5bb9", example="\u6210\u529f\uff01")
    private String message;
    @ApiModelProperty(value="\u4e1a\u52a1\u662f\u5426\u6210\u529f", example="true")
    private Boolean success;
    @ApiModelProperty(value="\u8fd4\u56de\u7684\u6570\u636e", example="{}")
    private T data;
    @ApiModelProperty(value="\u7cfb\u7edf\u54cd\u5e94\u7684\u65f6\u95f4\u6233", example="112345644446")
    private Long timestamp;

    public static <T> ResResultVO success(T t) {
        ResResultVO<T> resResultVO = new ResResultVO<T>();
        resResultVO.setCode(ResultCodeEnum.SUCCESS.getCode());
        resResultVO.setMessage(ResultCodeEnum.SUCCESS.getMsg());
        resResultVO.setData(t);
        resResultVO.setSuccess(true);
        resResultVO.setTimestamp(System.currentTimeMillis());
        return resResultVO;
    }

    public static <T> ResResultVO fail(String code, String message) {
        ResResultVO<T> resResultVO = new ResResultVO<T>();
        resResultVO.setCode(code);
        resResultVO.setMessage(message);
        resResultVO.setSuccess(false);
        resResultVO.setTimestamp(System.currentTimeMillis());
        return resResultVO;
    }

    public static <T> ResResultVO fail(String code, String message, T t) {
        ResResultVO<T> resResultVO = new ResResultVO<T>();
        resResultVO.setCode(code);
        resResultVO.setMessage(message);
        resResultVO.setData(t);
        resResultVO.setSuccess(false);
        resResultVO.setTimestamp(System.currentTimeMillis());
        return resResultVO;
    }

    public static ResResultVO exception(String code, String message) {
        return ResResultVO.fail(code, message);
    }

    public static ResResultVO exception(CommonException ce) {
        return ResResultVO.fail(ce.getCode(), ce.getMessage());
    }

    public static <T> ResResultVO exception() {
        ResResultVO<T> resResultVO = new ResResultVO<T>();
        resResultVO.setCode(ResultCodeEnum.ERR.getCode());
        resResultVO.setMessage(ResultCodeEnum.ERR.getMsg());
        resResultVO.setSuccess(false);
        resResultVO.setTimestamp(System.currentTimeMillis());
        return resResultVO;
    }

    public static <T> ResResultVO exception(String message) {
        ResResultVO<T> resResultVO = new ResResultVO<T>();
        resResultVO.setCode(ResultCodeEnum.ERR.getCode());
        resResultVO.setMessage(message);
        resResultVO.setSuccess(false);
        resResultVO.setTimestamp(System.currentTimeMillis());
        return resResultVO;
    }

    public static ResResultVO build(ResultCodeEnum resultCodeEnum) {
        return ResResultVO.fail(resultCodeEnum.getCode(), resultCodeEnum.getMsg());
    }

    public static ResResultVO build(ExceptionRsType exceptionRsType) {
        return ResResultVO.fail(exceptionRsType.getCode(), exceptionRsType.getMsg());
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResResultVO)) {
            return false;
        }
        ResResultVO other = (ResResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "ResResultVO(code=" + this.getCode() + ", message=" + this.getMessage() + ", success=" + this.getSuccess() + ", data=" + this.getData() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

