/*
 * Decompiled with CFR 0.152.
 */
package cn.strongculture.prometheusspringbootstarter.service.impl;

import cn.strongculture.prometheusspringbootstarter.config.SpringMetricsRegistry;
import cn.strongculture.prometheusspringbootstarter.service.MetricCounter;
import cn.strongculture.prometheusspringbootstarter.service.MetricTimer;
import cn.strongculture.prometheusspringbootstarter.service.MetricsClient;
import cn.strongculture.prometheusspringbootstarter.service.impl.SpringMetricCounter;
import cn.strongculture.prometheusspringbootstarter.service.impl.SpringMetricGauge;
import cn.strongculture.prometheusspringbootstarter.service.impl.SpringMetricTimer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class SpringMetricsClient
implements MetricsClient {
    private static Logger log = LoggerFactory.getLogger(SpringMetricsClient.class);
    @Autowired
    @Lazy
    private SpringMetricsRegistry register;
    private Set<SpringMetricGauge> gauges = ConcurrentHashMap.newKeySet();
    private ConcurrentMap<String, MetricCounter> counters = new ConcurrentHashMap<String, MetricCounter>();
    private ConcurrentMap<String, MetricTimer> timers = new ConcurrentHashMap<String, MetricTimer>();

    @PreDestroy
    public void destroy() {
        this.gauges.clear();
        this.counters.clear();
        this.timers.clear();
    }

    @Override
    public void gauge(String metricName, String description, Map<String, String> tagMap, Callable<Double> callable) {
        SpringMetricGauge g = new SpringMetricGauge(metricName, description, tagMap, callable);
        if (this.gauges.add(g)) {
            this.register.registerGauge(g);
            log.debug("gauge metric added for: {}", (Object)g);
        } else {
            log.error("duplicated gauge: {}", (Object)g);
        }
    }

    @Override
    public MetricCounter counter(String metricName, String description, Map<String, String> tagMap) {
        String key = this.getKey(metricName, tagMap);
        MetricCounter c = (MetricCounter)this.counters.get(key);
        if (c == null) {
            c = this.counters.computeIfAbsent(key, k -> this.getSpringMetricCounter(metricName, description, tagMap));
        }
        return c;
    }

    @Override
    public MetricTimer timer(String metricName, String description, Map<String, String> tagMap) {
        String key = this.getKey(metricName, tagMap);
        MetricTimer t = (MetricTimer)this.timers.get(key);
        if (t == null) {
            t = this.timers.computeIfAbsent(key, k -> this.getSpringMetricTimer(metricName, description, tagMap));
        }
        return t;
    }

    private MetricTimer getSpringMetricTimer(String metricName, String description, Map<String, String> tagMap) {
        return new SpringMetricTimer(metricName, tagMap, this.register.registerTimer(metricName, description, tagMap));
    }

    private MetricCounter getSpringMetricCounter(String metricName, String description, Map<String, String> tagMap) {
        return new SpringMetricCounter(metricName, tagMap, this.register.registerCounter(metricName, description, tagMap));
    }

    private String getKey(String metricName, Map<String, String> tagMap) {
        return metricName + (tagMap != null ? tagMap.toString() : "");
    }

    public Set<SpringMetricGauge> getGauges() {
        return this.gauges;
    }

    public Map<String, MetricCounter> getCounters() {
        return this.counters;
    }

    public Map<String, MetricTimer> getTimers() {
        return this.timers;
    }
}

