/*
 * Decompiled with CFR 0.152.
 */
package cn.strongculture.prometheusspringbootstarter.config;

import cn.strongculture.prometheusspringbootstarter.service.impl.SpringMetricGauge;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringMetricsRegistry
implements MeterBinder {
    private static Logger log = LoggerFactory.getLogger(SpringMetricsRegistry.class);
    private volatile MeterRegistry registry;

    @PreDestroy
    public void destroy() {
        if (this.registry != null && !this.registry.isClosed()) {
            this.registry.close();
        }
    }

    public void bindTo(MeterRegistry registry) {
        if (this.registry == null) {
            this.registry = registry;
            log.debug("MeterRegistry is set...");
        }
    }

    public Gauge registerGauge(SpringMetricGauge g) {
        this.checkState();
        List<Tag> tags = this.getTags(g.getTagMap());
        return Gauge.builder((String)g.getMetricsName(), g.getCallable(), SpringMetricGauge.metricFunc).tags(tags).description(g.getDescription()).register(this.registry);
    }

    public Counter registerCounter(String metricsName, String description, Map<String, String> tagMap) {
        this.checkState();
        List<Tag> tags = this.getTags(tagMap);
        return Counter.builder((String)metricsName).tags(tags).description(description).register(this.registry);
    }

    public Timer registerTimer(String metricsName, String description, Map<String, String> tagMap) {
        this.checkState();
        List<Tag> tags = this.getTags(tagMap);
        return Timer.builder((String)metricsName).tags(tags).description(description).register(this.registry);
    }

    private List<Tag> getTags(Map<String, String> tagMap) {
        return tagMap.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() {
        if (this.registry == null) {
            SpringMetricsRegistry springMetricsRegistry = this;
            synchronized (springMetricsRegistry) {
                if (this.registry == null) {
                    this.registry = new SimpleMeterRegistry();
                }
            }
        }
        if (this.registry == null) {
            throw new IllegalStateException("Metrics registry is not initialized yet!");
        }
    }
}

