/*
 * Decompiled with CFR 0.152.
 */
package cn.strongculture.prometheusspringbootstarter.config;

import cn.strongculture.prometheusspringbootstarter.config.SpringMetricsRegistry;
import cn.strongculture.prometheusspringbootstarter.service.MetricTimer;
import cn.strongculture.prometheusspringbootstarter.service.MetricsClient;
import cn.strongculture.prometheusspringbootstarter.service.impl.SpringMetricsClient;
import com.google.common.util.concurrent.AtomicDouble;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsClient.class})
public class SpringMetricsAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(SpringMetricsAutoConfiguration.class);
    @Autowired
    private MetricsClient metricsClient;
    @Value(value="${monitor.api.pointcut.expression:execution(public * a.b.c.d..*.*(..))}")
    private String apiMonitorPointcutExpression;
    private Lock lock = new ReentrantLock();
    private Map<Method, AtomicDouble> concurrentExecutionCount = new ConcurrentHashMap<Method, AtomicDouble>();

    @Bean
    public AspectJExpressionPointcutAdvisor getAspectJExpressionPointcutAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(this.apiMonitorPointcutExpression);
        advisor.setAdvice((Advice)((MethodInterceptor)invocation -> {
            Object result = null;
            Method method = invocation.getMethod();
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("method", method.getName());
            tags.put("class", this.getSimplifiedClassName(method.getDeclaringClass()));
            long startTime = System.currentTimeMillis();
            try {
                if (!this.concurrentExecutionCount.containsKey(method)) {
                    this.addGauge(method);
                }
                this.concurrentExecutionCount.get(method).addAndGet(1.0);
                result = invocation.proceed();
                tags.put("status", "OK");
            }
            catch (Exception e) {
                tags.put("status", "EXCEPTION");
                throw e;
            }
            finally {
                this.concurrentExecutionCount.get(method).addAndGet(-1.0);
                MetricTimer timer = this.metricsClient.timer("api_cost", "Monitoring interface time consumption", tags);
                timer.record(System.currentTimeMillis() - startTime);
            }
            return result;
        }));
        return advisor;
    }

    private String getSimplifiedClassName(Class<?> classObj) {
        return classObj.getName().replaceAll("([^\\.])[^\\.]*\\.", "$1.");
    }

    private void addGauge(final Method method) {
        try {
            this.lock.lock();
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("method", method.getName());
            tags.put("class", this.getSimplifiedClassName(method.getDeclaringClass()));
            this.concurrentExecutionCount.put(method, new AtomicDouble(0.0));
            this.metricsClient.gauge("api_concurrent_execution_current", "Instantaneous concurrency of interfaces", tags, new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ((AtomicDouble)SpringMetricsAutoConfiguration.this.concurrentExecutionCount.get(method)).get();
                }
            });
        }
        catch (Exception e) {
            logger.error("addGauge error " + method.getName(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Bean
    @Qualifier(value="metricsClient")
    @ConditionalOnMissingBean
    public MetricsClient metricsClient() {
        return new SpringMetricsClient();
    }

    @Bean
    public SpringMetricsRegistry springMetricsRegister() {
        return new SpringMetricsRegistry();
    }
}

