/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.test.util;

import cn.sticki.spel.validator.test.util.BeanUtil;
import cn.sticki.spel.validator.test.util.IGetter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class VerifyFailedField {
    String name;
    String message;

    private VerifyFailedField() {
    }

    public static VerifyFailedField of(String fieldName) {
        return VerifyFailedField.of(fieldName, null);
    }

    public static <T> VerifyFailedField of(IGetter<T, ?> field) {
        return VerifyFailedField.of(field, null);
    }

    @SafeVarargs
    public static <T> List<VerifyFailedField> of(IGetter<T, ?> ... fields) {
        return Arrays.stream(fields).map(VerifyFailedField::of).collect(Collectors.toList());
    }

    public static <T> VerifyFailedField of(IGetter<T, ?> field, String errorMessage) {
        return VerifyFailedField.of(BeanUtil.getFieldName(field), errorMessage);
    }

    public static VerifyFailedField of(String fieldName, String errorMessage) {
        VerifyFailedField verifyFailedField = new VerifyFailedField();
        verifyFailedField.setName(fieldName);
        verifyFailedField.setMessage(errorMessage);
        return verifyFailedField;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyFailedField)) {
            return false;
        }
        VerifyFailedField other = (VerifyFailedField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerifyFailedField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VerifyFailedField(name=" + this.getName() + ", message=" + this.getMessage() + ")";
    }
}

