/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.test.util;

import cn.sticki.spel.validator.test.util.ID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogContext.class);

    public static void setValidateObject(Object object) {
        String className = object.getClass().getSimpleName();
        Class<?> enclosingClass = object.getClass().getEnclosingClass();
        if (enclosingClass != null) {
            className = enclosingClass.getSimpleName() + "." + className;
        }
        MDC.put((String)"className", (String)className);
        MDC.put((String)"fullClassName", (String)LogContext.abbreviate(object.getClass().getName()));
        if (object instanceof ID) {
            MDC.put((String)"id", (String)String.valueOf(((ID)object).getId()));
        }
    }

    public static void clearValidateObject() {
        MDC.remove((String)"id");
        MDC.remove((String)"className");
        MDC.remove((String)"fieldName");
        MDC.remove((String)"fullClassName");
    }

    public static void set(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public static void remove(String key) {
        MDC.remove((String)key);
    }

    private static String abbreviate(String className) {
        String[] parts = className.split("\\.");
        StringBuilder abbreviated = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            abbreviated.append(parts[i].charAt(0)).append(".");
        }
        abbreviated.append(parts[parts.length - 1]);
        return abbreviated.toString();
    }
}

