/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.test.util;

import cn.sticki.spel.validator.core.result.FieldError;
import cn.sticki.spel.validator.core.result.ObjectValidResult;
import cn.sticki.spel.validator.test.util.ConstraintViolationSet;
import cn.sticki.spel.validator.test.util.LogContext;
import cn.sticki.spel.validator.test.util.VerifyFailedField;
import cn.sticki.spel.validator.test.util.VerifyObject;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpelValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSpelValidator.class);

    public abstract ObjectValidResult validate(Object var1, String[] var2);

    public boolean checkConstraintResult(List<VerifyObject> verifyObjectList) {
        int failCount = 0;
        for (VerifyObject verifyObject : verifyObjectList) {
            if (this.checkConstraintResult(verifyObject)) continue;
            ++failCount;
        }
        return failCount == 0;
    }

    public boolean checkConstraintResult(VerifyObject verifyObject) {
        Object object = verifyObject.getObject();
        String[] spelGroups = verifyObject.getSpelGroups();
        Collection<VerifyFailedField> verifyFailedFields = verifyObject.getVerifyFailedFields();
        boolean expectException = verifyObject.isExpectException();
        LogContext.setValidateObject(object);
        log.info("Start checking object: {}", object);
        int failCount = 0;
        try {
            ObjectValidResult validResult = this.validate(object, spelGroups);
            failCount += this.processVerifyResult(verifyFailedFields, ConstraintViolationSet.of(validResult.getErrors()));
        }
        catch (Exception e) {
            if (expectException) {
                log.info("Passed, Capture exception {}, message: {}", e.getClass(), (Object)e.getMessage());
                expectException = false;
            }
            log.error("Failed, Capture exception {}, message: {}", e.getClass(), (Object)e.getMessage());
            ++failCount;
        }
        if (expectException) {
            log.error("Failed, No exception captured");
            ++failCount;
        }
        if (failCount == 0) {
            log.info("Verification end, all passed");
        } else {
            log.error("Verification end, number of failures: {}", (Object)failCount);
        }
        log.info("------------------------------------------------------------------------");
        LogContext.clearValidateObject();
        return failCount == 0;
    }

    private int processVerifyResult(Collection<VerifyFailedField> verifyFailedFields, ConstraintViolationSet violationSet) {
        String fieldNameLogKey = "fieldName";
        int failCount = 0;
        for (VerifyFailedField verifyFailedField : verifyFailedFields) {
            String fieldName = verifyFailedField.getName();
            LogContext.set("fieldName", fieldName);
            String message = verifyFailedField.getMessage();
            log.info("Expected exception information: {}", (Object)(message == null ? "ignore" : message));
            boolean fieldMatch = false;
            boolean find = false;
            FieldError fieldError = violationSet.getAndRemove(fieldName, message);
            if (fieldError != null) {
                find = true;
                log.info("Real exception information: {}", (Object)fieldError.getErrorMessage());
                if (message != null && !message.equals(fieldError.getErrorMessage())) {
                    log.error("Failed");
                } else {
                    fieldMatch = true;
                    log.info("Passed");
                }
            }
            if (!find) {
                log.error("Excess field");
            }
            if (fieldMatch) continue;
            ++failCount;
        }
        LogContext.remove("fieldName");
        for (FieldError violation : violationSet.getAll()) {
            log.error("Field [{}] is ignored", (Object)violation.getFieldName());
            ++failCount;
        }
        return failCount;
    }
}

